// JavaScript Document
$(document).ready(function (e) {

    formatResult = function (data) {
        return  data.text;
    };
//###########################################################################################################################################################
//######################################### productrequest controller   ##############################################################################################
//###########################################################################################################################################################
    $("#product").select2({
        placeholder: "إسم المنتج",
        minimumInputLength: 0,
        //minimumInputLength: 3,
        multiple: false,
        quietMillis: 100,
        ajax: {
            url: "productrequestajax.php?do=getProducts",
            dataType: 'json',
            data: function (term, page) {
                return {
                    term: term, //search term
                    page_limit: 10, // page size
                };
            },
            results: function (data) {
                return {results: data};
            }
        },
        formatResult: formatResult,
        initSelection: function (element, callback) {
            var item = element.val().split(':');
            var data = {id: item[0], text: item[1]};
            callback(data);
        }
    });
//###########################################################################################################################################################

    $('#searchInStores').live('click', function (e) {
        $('#productError').hide();
        var productId = $('#product').val();
        var storeId = $('#storeId').val();
        if (!productId)
        {
            $('#productError').show();
        }
        else
        {
            $.post('productrequestajax.php?do=productsearch', {productId: productId, storeId: storeId}, function (rslt) {
                $('#searchResult').html('');
                $('#searchResult').html(rslt);
                $(".positiveNo").forcepositiveNum();
            });
        }
    });
//###########################################################################################################################################################

    $('.requiredNo').live('keyup', function (e) {
        var itr = Number($(this).attr('data-itr'));
        var requiredNo = Number($('#requiredNo' + itr).val());
        var availableNo = Number($('#availableNo' + itr).val());

        console.log(requiredNo + '--' + availableNo);

        if (requiredNo > availableNo)
        {
            $('#requiredNoError' + itr).show();
        }
        else
        {
            $('#requiredNoError' + itr).hide();
        }
    });

//###########################################################################################################################################################

    $('.requestProduct').live('click', function (e) {

        var itr = Number($(this).attr('data-itr'));
        var requiredNo = Number($('#requiredNo' + itr).val());
        var availableNo = Number($('#availableNo' + itr).val());
        var storeId = Number($(this).attr('data-storeId'));
        var requestStoreId = $('#storeId').val();
        var productId = $('#product').val();


        //console.log(requiredNo + '--' + availableNo + '--' + storeId);

        if (requiredNo > availableNo)
        {
            $('#requiredNoError' + itr).show();
        }
        else
        {
            $('#requiredNoError' + itr).hide();
            $.post('productrequestajax.php?do=productrequest', {productId: productId, requiredNo: requiredNo, storeId: storeId, requestStoreId: requestStoreId}, function (rslt) {
                if (Number(rslt) == 1)
                {
                    $('#requestProduct' + itr).attr('disabled', true);
                    $('#requiredNo' + itr).attr('disabled', true);
                    $('#requestProductError' + itr).html('');
                    $('#requestProductError' + itr).html('تم ارسال الطلب ');
                    $('#requestProductError' + itr).css('color', 'green');
                    $('#requestProductError' + itr).show();
                }
                else
                {
                    $('#requestProductError' + itr).html('');
                    $('#requestProductError' + itr).html('خطأ أثناء الارسال ');
                    $('#requestProductError' + itr).css('color', 'red');
                    $('#requestProductError' + itr).show();
                }
            });
        }
    });

//###########################################################################################################################################################

    $('.decBtn').live('click', function (e) {
        var requestId = $(this).attr('data-requestId');
        var decision = $(this).attr('data-val');
        var itr = Number($(this).attr('data-itr'));
        var approvedNo = Number($('#approvedNo' + itr).val());


        var row = $(this).parent().parent();
        row.children(6).children().attr('disabled', true);
        row.children(7).children().attr('disabled', true);
        $.post('productrequestajax.php?do=requestdecision', {requestId: requestId, decision: decision, approvedNo: approvedNo}, function (rslt) {
            //alert(rslt);
            if (Number(rslt) == 1)
            {

            }
            else if (Number(rslt) == 2)
            {
                row.children(6).children().attr('disabled', false);
                row.children(7).children().attr('disabled', false);
                alert('العدد الموافق عليه اكبر من العدد المتاح فى المخزن ');
            }

        });
    });

//###########################################################################################################################################################

    $('.saveRequestOther').live('click', function (e) {
        $(this).attr('disabled',true);
        var requestTitle = $('#requestTitle').val();
        var requestTo = $('input[name=requestTo]:checked').val();
        var requestToSelectId;

        if (requestTo == 2)
        {
            requestToSelectId = 'userId';
        }
        else if (requestTo == 1)
        {
            requestToSelectId = 'userGroupId';
        }
        else
        {
            requestToSelectId = 'branchId';
        }

        var requestToId = $('#' + requestToSelectId).val();

        if (requestToId == -1)
        {
            $('#' + requestToSelectId + 'Error').show();
            $(this).attr('disabled',false);
        }
        if (requestTitle == '')
        {
            $('#requestTitleError').show();
            $(this).attr('disabled',false);
        }
        else if (requestToId != -1 && requestTitle != '')
        {
            //########## submit form
            $('#otherrequestsForm').submit();
        }

    });

//###########################################################################################################################################################

    $('.requestTo').live('change', function (e) {

        $('#userIdError').hide();
        $('#userGroupId').hide();
        $('#branchId').hide();


        if ($(this).val() == 1)      // user group
        {
            $('#toBranch').hide();
            $('#toUser').hide();
            $('#toUserGroup').show();
        }
        else if ($(this).val() == 2)   // user
        {
            $('#toBranch').hide();
            $('#toUser').show();
            $('#toUserGroup').hide();
        }
        else                            // branch
        {
            $('#toBranch').show();
            $('#toUser').hide();
            $('#toUserGroup').hide();
        }


    });


});