$(function () {
    $("#client").select2({
        placeholder: "العميل",
        //minimumInputLength: document.getElementById("searchvalue").value,
        inimumInputLength: 0,
        multiple: false,
        quietMillis: 100,
        ajax: {
            url: "clientControllerAjax.php?do=select2ClientsAjax",
            dataType: 'json',
            data: function (term, page) {
                return {
                    term: term, //search term
                    page_limit: 7, // page size
                    withAddOption: 1,
                    withNakdi: 0,
                    //withAddOption: 1,
                };
            },
            results: function (data) {
                return {results: data};
            }
        },
        formatResult: function (data) {
            if (Number(data.id) == -2) {
                return  '<span class="newoption">' + data.text + '</span >';
            } else {
                return  '<span>' + data.text + '</span >';
            }
        },
        initSelection: function (element, callback) {
            var item = element.val().split(':');
            //  var data = {id: item[0], text: item[1]};
            var data = {id: item[0], text: item[1], productquantity: item[2], price: item[3]};
            callback(data);
        },
        //dropdownCssClass: "bigdrop", // apply css that makes the dropdown taller
    }).on('select2-loaded', function (e) {// not "select2-open" nor "select2-opening" //http://mkurz.github.io/select2/index.html
        $('.newoption').parent().addClass('newoption');
    }).on('select2-selecting', function (e) {
        var val = e.val;
        if (val == "-2") {
            $('#myModal1').modal('show');
        } else {
            getclienttamweendata(val);
        }
    });
    //this is needed for ajax =>to obtain id from it  and use in ajax
    $('#client').select2('data', {id: $('#oldclientid').val(), text: $('#oldclientname').val()});

    $('#saveTamwinBill').live('click', function () {
        var checkflag = validateTheForm();
        if (!$(this).hasClass('processing') && checkflag == 1) {
            $('#tameenForm').submit();
        } else {
            $(this).removeClass('processing');
        }
    });

    if ($('#id').length > 0) {//edit
        getclienttamweendata($('#oldclientid').val());
    }
});
function getclienttamweendata(id) {
    $.ajax({
        type: "POST",
        url: 'clientControllerAjax.php?do=getclienttamweendata',
        data: {client: id},
        async: false,
        success: function (data) {
            data = JSON.parse(data);
            if ($('#id').length > 0) {//edit
                var q = Number($('#quantity').val());
                data.cardTakenAmount = data.cardTakenAmount - q;
                data.remaining = data.remaining + q;
            }
            $('#noOfPersonsDa3m_').val(data.noOfPersonsDa3m);
            $('#cardSahre').val(data.cardShare);
            $('#cardTakenAmount').val(data.cardTakenAmount);
            $('#remaining').val(data.remaining);
            $('#noOfPersonsTamween').val(data.noOfPersonsTamween);
            if (data.tamweenStatus == 1) {
                $('#tamweenStatus').attr('checked', 'checked');
                $('#tamweenStatus').attr('disabled', 'disabled');
                //
                $('#userTamween').val(data.userTamween);
                $('#dateTamween').val(data.dateTamween);
            } else {
                $('#tamweenStatus').removeAttr('checked');
                $('#tamweenStatus').removeAttr('disabled');
                //
                $('#userTamween').val("");
                $('#dateTamween').val("");
            }
        }
    });
}
function validateTheForm() {
    var flag = 1;
    if (Number($('#client').val()) < 1) {
        flag = 0;
        alert('عفوا لم تختر العميل');
    } else if ($('#quantity').val() == "") {
        flag = 0;
        $('#quantity').css('background-color', 'yellow');
    } else if (Number($('#quantity').val()) > Number($('#remaining').val())) {
        flag = 0;
        $('#quantity').css('background-color', 'yellow');
        alert('عفوا كمية الصرف تجاوزت باقى الحصة');
    } else {
        $('#quantity').css('background-color', 'white');
    }
    return flag;
}



//client modal js
$('.savemodel1').on('click', function () {
    $.ajax({
        type: 'POST',
        url: 'clientControllerAjax.php?do=addclient&simplereturn=1',
        data: $("#clientInfo").serialize(),
        success: function (data) {
//alert(data);
            if (data == '2')//اسم العميل مكرر
            {
                $("#newclientName").val("");
                $("#nameError").css("display", "block");
                $('#debt').html("0");
                document.getElementById("hidden_debt").value = 0;
            }
            else
            {
                if (data == "3") //كود العميل مكرر
                {
                    alert('كود العميل مكرر');
                }
                else if (data == "1") //ادخل اسم العميل
                {
                    alert('ادخل اسم العميل');
                }
                else//success
                {

                    //alert("يرجى إدخال البيانات بشكل صحيح");
                    $('#myModal1').modal('hide');

                    $('#client').select2('data', {id: data, text: $('#newclientName').val()});
                    $('#client').trigger('select2-selecting');

                    //empty modal box's inputs' values
                    emptyClientModalForm();
                    $("select.selectx1").select2();

                    //$("#client").trigger('change');
                }
            }
        }
    });

});




$('.savemodel2').on('click', function () {


    $('#myModal1').modal('hide');

    $('#client').select2('data', {id: '', text: ''});
    $('select').select2();

//    $('#debt').html("0");
//    document.getElementById("hidden_debt").value = 0;

    emptyClientModalForm();
});





function emptyClientModalForm()
{

    $('#clientInfo').find(':input').each(function () {
        var type = this.type, tag = this.tagName.toLowerCase();
        if (type == 'text' || type == 'password' || tag == 'textarea')
            this.value = '';
        else if (type == 'checkbox' || type == 'radio')
            this.checked = false;
        else if (tag == 'select')
            this.value = '-1';
    });
}