<?php

/**
 * Class that operate on table 'supplier'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SupplierMySqlExtDAO extends SupplierMySqlDAO {

    public function insertFirstSupplier($supplier) {
        $sql = 'INSERT INTO supplier (supplierid, suppliername, supplieraddress, supplierphone, suppliercurrentDebt, supplierdetails, conditions, userid, supplierdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplier->supplierid);
        $sqlQuery->set($supplier->suppliername);
        $sqlQuery->set($supplier->supplieraddress);
        $sqlQuery->set($supplier->supplierphone);
        $sqlQuery->set($supplier->suppliercurrentDebt);
        $sqlQuery->setString2($supplier->supplierdetails);
        $sqlQuery->setNumber($supplier->conditions);
        $sqlQuery->setNumber($supplier->userid);
        $sqlQuery->set($supplier->supplierdate);

        $this->executeInsert($sqlQuery);
        return $id;
    }

    public function loadExt($id) {
        $sql = 'SELECT * FROM supplier WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getList($sqlQuery);
    }

    public function updatedept($supplier) {
        $sql = 'UPDATE supplier SET  suppliercurrentDebt = ?, userid = ?, supplierdate = ?   WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->set($supplier->suppliercurrentDebt);

        $sqlQuery->setNumber($supplier->userid);
        $sqlQuery->set($supplier->supplierdate);

        $sqlQuery->setNumber($supplier->supplierid);
        return $this->executeUpdate($sqlQuery);
    }

    public function updateSuppDept($supid, $Supdebt) {
        $sql = 'UPDATE supplier SET  suppliercurrentDebt = "' . $Supdebt . '"
		        WHERE supplierid = "' . $supid . '"';

        $sqlQuery = new SqlQuery($sql);

        //print_r($sqlQuery);

        return $this->executeUpdate($sqlQuery);
    }

    //pagination
    public function queryAllWithLimit($startpoint, $perpage) {
        $sql = 'SELECT * FROM supplier
				ORDER BY supplierid ASC
				limit ' . $startpoint . ',' . $perpage . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllForShow() {
        $sql = 'SELECT * FROM supplier
				ORDER BY supplierid ASC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllsup() {
        $sql = 'SELECT * FROM supplier WHERE conditions=0 ORDER BY supplierdate DESC ,supplierid DESC  ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function querysuppliercurrentDebt($id) {
        $sql = 'SELECT suppliercurrentDebt
				from supplier
				where supplierid= "' . $id . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /*
     * Update record in table to make conditions field = 1 to mark deleted status.
     */

    public function deletetemp($supplierid) {

        $sql = 'UPDATE supplier SET conditions = 1
		        WHERE supplierid =' . $supplierid . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function returndelete($supplierid) {

        $sql = 'UPDATE supplier SET conditions = 0
		        WHERE supplierid =' . $supplierid . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function loadSupplierBySupplierdebtchangeId($supplierdebtchangeid) {
        $sql = 'SELECT suppliername
		FROM supplier, supplierdebtchange
		WHERE supplierdebtchangeid = ?
		AND supplier.supplierid = supplierdebtchange.supplierid';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($supplierdebtchangeid);
        return $this->getRow($sqlQuery);
    }

    public function getSuppliersTotalDept() {
        $sql = 'SELECT SUM(suppliercurrentDebt)
		FROM supplier
		WHERE conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function getSuppliernamefrombuybill($buybiilid) {
        $sql = 'SELECT supplier.suppliername,supplier.supplierid
				FROM `supplier`
				LEFT JOIN buybill ON buybill.buybillsupplierid = supplier.`supplierid`
				LEFT JOIN buyandruternbill ON buyandruternbill.buybillsupplierid = supplier.`supplierid`
				WHERE buybill.buybillid =' . $buybiilid . '
				OR buyandruternbill.buybillid =' . $buybiilid . '';

        //print_r("<br>".$sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function getAutoIncrementValue($DBName) {
        $sql = 'SELECT `AUTO_INCREMENT`
                FROM  INFORMATION_SCHEMA.TABLES
                WHERE TABLE_SCHEMA = "' . $DBName . '"
                AND   TABLE_NAME   = "supplier" ';

        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function checkCategory($category) {
        $sql = 'SELECT * FROM supplier WHERE conditions=0 and category_id LIKE "%' . $category . '%"';
//        echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }


}



?>