<?php

/**
 * Class that operate on table 'save'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-08-07 11:25
 */
class SaveMySqlExtDAO extends SaveMySqlDAO {

    public function insertFirstSave($save, $savedetails) {
        $sql = 'INSERT INTO save (saveid, savename, savecurrentvalue, savedetails, savedate, conditions, userid) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->setNumber($save->saveid);
        $sqlQuery->set($save->savename);
        $sqlQuery->set($save->savecurrentvalue);
        $sqlQuery->setString2($savedetails);
        $sqlQuery->set($save->savedate);
        $sqlQuery->setNumber($save->conditions);
        $sqlQuery->setNumber($save->userid);

        $this->executeInsert($sqlQuery);
        return $id;
    }

    public function queryAllWithOrder() {
        $sql = 'SELECT * FROM save order by saveid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateDele($save) {
        $sql = 'UPDATE save SET savedate = ?, conditions = ?, userid = ? WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($save->savedate);
        $sqlQuery->setNumber($save->conditions);
        $sqlQuery->setNumber($save->userid);

        $sqlQuery->setNumber($save->saveid);
        return $this->executeUpdate($sqlQuery);
    }

    public function updateSaveValue($save) {
        $sql = 'UPDATE save SET  savecurrentvalue = ?,  userid = ? WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($save->savecurrentvalue);
        $sqlQuery->setNumber($save->userid);

        $sqlQuery->setNumber($save->saveid);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryWithConditionExpectId($saveid) {
        $sql = 'SELECT * FROM save where conditions = 0 and saveid != ' . $saveid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function getSaveTotalCurrentValue() {
        $sql = 'SELECT SUM(savecurrentvalue) FROM save where conditions = 0 ';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function getTotalSaves() {
        $sql = 'SELECT SUM(savecurrentvalue)
			FROM save
			WHERE conditions=0
			';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    #############################################################

    //fatma
    ##for many users updating same cell
//    public function updateinDBDirectly($amount, $saveid) {
//        $sql = "UPDATE save SET
//                `savecurrentvalue` = @max_limbs := `savecurrentvalue`+$amount
//                WHERE `saveid`='$saveid' LIMIT 1;
//                SELECT @max_limbs as savecurrentvalue;";
//        $sqlQuery = new SqlQuery($sql);
////        return $this->executeUpdate($sqlQuery);
//        return $this->QuerySingleResult($sqlQuery);
//    }

    public function loadForUpdateEx($id) {
        $sql = 'SELECT save.* ,currency.conversionFactor
                FROM save
                left join currency on currency.id = save.currencyId
                WHERE saveid = ? FOR UPDATE';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    #############################################################

    public function queryAllEX($savename, $queryString = '') {
        $sql = 'SELECT *
                FROM save
                where conditions=0 and savename like  "%' . $savename . '%" ' . $queryString . '
                order by saveid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllEX2($queryString = '') {
        $sql = 'SELECT save.*,currency.name as currencyName,currency.conversionFactor,ROUND((save.savecurrentvalue/currency.conversionFactor),2) as savecurrentvalueInMainCurrency
                FROM save
                join currency on currency.id = save.currencyId
                where save.conditions=0 ' . $queryString . '
                order by saveid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>