<?php

/**
 * Class that operate on table 'productunit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProductunitMySqlExtDAO extends ProductunitMySqlDAO {

    public function queryByProductidExt($value) {
        $sql = 'SELECT * FROM productunit WHERE productid = ? AND conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function getfirstunitt($value) {
        $sql = 'SELECT * FROM productunit WHERE productid = ?   order by productunit.productunitid  LIMIT 1';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getRow($sqlQuery);
    }

    public function getfirstunittWithProductNumberEQ1($value) {
        $sql = 'SELECT * FROM productunit WHERE productid = ? and productnumber = 1 and conditions = 0 order by productunit.productunitid  LIMIT 1';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getRow($sqlQuery);
    }

    //public function queryCatUnitsAndProductUnits($value){
//		$sql = 'SELECT productunit.* ,  productcatunit.unitid as catUnitId
//		FROM product
//		JOIN productunit
//		ON productunit. = product.
//		JOIN productcatunit
//
//		WHERE productid = ?
//		AND conditions = 0' ;
//		$sqlQuery = new SqlQuery($sql);
//		$sqlQuery->setNumber($value);
//		return $this->getList($sqlQuery);
//	}
//

    public function queryWithProductIdAndCondition($productid) {
        $sql = 'SELECT productunit.*, unit.unitName
		 FROM productunit JOIN unit
		 ON productunit.unitid = unit.unitId
		 where productunit.productid = ' . $productid . ' and unit.conditions = 0
		  and productunit.conditions = 0';


        //print_r($sql.'<br>');
        $sqlQuery = new SqlQuery($sql);

        return $this->getList($sqlQuery);
    }

    public function queryWithProductId($productid) {
        $sql = 'SELECT productunit.*, unit.unitName
		 FROM productunit JOIN unit
		 ON productunit.unitid = unit.unitId
		 where productunit.productid = ' . $productid;



        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithProductIdAndUnitId($productid, $unitid) {
        $sql = 'SELECT productunit.*, unit.unitName,product.overAllAveragePrice
		 FROM productunit JOIN unit
		 ON productunit.unitid = unit.unitId
		 join product on product.productId = productunit.productid
		 where productunit.productid = ' . $productid . '
		 and productunit.productunitid = ' . $unitid . '
		  and unit.conditions = 0
		  and productunit.conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        //print_r('<br>' . $sql . '<br>');
        return $this->getRow($sqlQuery);
    }

    public function getProductNumber($productunitid) {
        $sql = 'SELECT productunit.productnumber
		FROM productunit
		 where productunit.productunitid = ' . $productunitid . '';
        $sqlQuery = new SqlQuery($sql);
        // print($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function queryWithProductIdAndConditionExt($productid) {
        $sql = 'SELECT productunit.unitid, productunit.productunitid
		 FROM productunit JOIN unit
		 ON productunit.unitid = unit.unitId
		 where productunit.productid = ' . $productid . ' and unit.conditions = 0
		 and productunit.conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        //print_r($sql);
        return $this->getList($sqlQuery);
    }

    public function insertwithid($productunit) {
        $sql = 'INSERT INTO productunit (productunitid,unitid, productid, productnumber, productunitdate, userid, conditions) VALUES (?,?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productunit->productunitid);
        $sqlQuery->setNumber($productunit->unitid);
        $sqlQuery->setNumber($productunit->productid);
        $sqlQuery->setNumber($productunit->productnumber);
        $sqlQuery->set($productunit->productunitdate);
        $sqlQuery->setNumber($productunit->userid);
        $sqlQuery->setNumber($productunit->conditions);

        $id = $this->executeInsert($sqlQuery);
        $productunit->productunitid = $id;
        return $id;
    }

    public function updatecondation($productunitid) {
        $sql = 'UPDATE productunit SET  conditions = 1 WHERE productunitid = ' . $productunitid . '';


        //print_r($sql.'<br>');
        $sqlQuery = new SqlQuery($sql);


        return $this->executeUpdate($sqlQuery);
    }

    public function getMaxUnitOfAProduct($value) {
        $sql = ' SELECT productunit.*,unit.unitName FROM productunit
		JOIN unit ON productunit.unitid = unit.unitId
		 WHERE productunit.productid = ? ORDER BY productunit.productnumber DESC LIMIT 1 ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getRow($sqlQuery);
    }

    public function queryWithProductIdAndUnitIdSimple($productid, $unitid) {
        $sql = 'SELECT productunit.*
		 FROM productunit
		 where productunit.productid = ' . $productid . '
		 and productunit.unitid = ' . $unitid . '';
        $sqlQuery = new SqlQuery($sql);
        //print_r('<br>' . $sql . '<br>');
        return $this->getList($sqlQuery);
    }

    public function updateEX($productunit) {
        $sql = 'UPDATE productunit SET unitid = ?, productid = ?, productnumber = ?, productunitdate = ?, userid = ?, conditions = ? WHERE productunitid in ( ' . $productunit->productunitid . ')';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productunit->unitid);
        $sqlQuery->setNumber($productunit->productid);
        $sqlQuery->setNumber($productunit->productnumber);
        $sqlQuery->set($productunit->productunitdate);
        $sqlQuery->setNumber($productunit->userid);
        $sqlQuery->setNumber($productunit->conditions);

        //$sqlQuery->setNumber($productunit->productunitid);
        //echo $sql;
        return $this->executeUpdate($sqlQuery);
    }

    public function getUnitDataOfUnityWithProductId($productid) {
        $sql = 'SELECT productunit.unitid, unit.unitName as conditions
		 FROM productunit
                 JOIN unit ON productunit.unitid = unit.unitId
		 where productunit.productid = ' . $productid . ' and unit.conditions = 0
		 and productunit.conditions = 0
                 and productunit.productnumber = 1';
        $sqlQuery = new SqlQuery($sql);
        //print_r($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryByProUnitParcode($proUnitParcode) {
        $sql = 'SELECT * FROM productunit WHERE proUnitParcode = "' . $proUnitParcode . '" and conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithProUnitParcodeAndId($proUnitParcode, $productunitid) {
        $sql = 'SELECT * FROM productunit
		    where productunitid  != ' . $productunitid . '
		    and proUnitParcode = "' . $proUnitParcode . '" and conditions = 0';

        //print_r('<br>'.$sql.'<br>');
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

}

?>