<?php

/**
 * Class that operate on table 'partnerwithdrawal'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class PartnerwithdrawalMySqlExtDAO extends PartnerwithdrawalMySqlDAO {

    public function queryWithOrder() {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOrderLimited($start, $end) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 order by partnerwithdrawalid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithPartnerId($partnerid) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.partnerid =' . $partnerid . '
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithPartnerIdLimited($start, $end, $partnerid) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.partnerid =' . $partnerid . '
		 order by partnerwithdrawalid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithPartnerType($partnertype) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.partenrwithdrawaltype =' . $partnertype . '
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithSaveId($saveid) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.saveid =' . $saveid . '
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithSaveIdLimited($start, $end, $saveid) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.saveid =' . $saveid . '
		 order by partnerwithdrawalid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDate($startDate, $endDate) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.partnerwithdrawaldate >= "' . $startDate . '" and partnerwithdrawal.partnerwithdrawaldate <= "' . $endDate . '"
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOneDateOnly($condition, $date) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.partnerwithdrawaldate' . $condition . '"' . $date . '"
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateLimited($start, $end, $startDate, $endDate) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and partnerwithdrawal.partnerwithdrawaldate >= "' . $startDate . '" and partnerwithdrawal.partnerwithdrawaldate <= "' . $endDate . '"
		 order by partnerwithdrawalid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function loadPartnerwithdrawalById($partnerwithdrawalid) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
			 FROM partnerwithdrawal JOIN partner
			 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
			 ON partnerwithdrawal.saveid = save.saveid
			 where partner.conditions = 0 and save.conditions = 0
			 and partnerwithdrawalid =' . $partnerwithdrawalid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function updateConditions($partnerwithdrawal) {
        $sql = 'UPDATE partnerwithdrawal SET  partnerwithdrawaldate = ?, userid = ?, conditions = ?,
        partnerbefore=?, partnerafter = ? WHERE partnerwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($partnerwithdrawal->partnerwithdrawaldate);
        $sqlQuery->setNumber($partnerwithdrawal->userid);
        $sqlQuery->setNumber($partnerwithdrawal->conditions);
        $sqlQuery->set($partnerwithdrawal->partnerbefore);
        $sqlQuery->set($partnerwithdrawal->partnerafter);

        $sqlQuery->setNumber($partnerwithdrawal->partnerwithdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryWithDateAndConditions($startDate, $endDate) {
        $sql = 'SELECT * FROM partnerwithdrawal
		where partnerwithdrawaldate >= "' . $startDate . '" and partnerwithdrawaldate <= "' . $endDate . '"
		and conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsExt($startDate, $endDate) {
        $sql = 'SELECT SUM(partnerwithdrawalvalue) FROM partnerwithdrawal
		where partnerwithdrawaldate >= "' . $startDate . '" and partnerwithdrawaldate <= "' . $endDate . '"
		and conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function search($querystring) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 ' . $querystring . '
		 and partner.conditions = 0 and save.conditions = 0
		 order by partnerwithdrawalid desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryStringSearch($queryString) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename
		 FROM partnerwithdrawal JOIN partner
		 ON partnerwithdrawal.partnerid = partner.partnerid JOIN save
		 ON partnerwithdrawal.saveid = save.saveid
		 where partner.conditions = 0 and save.conditions = 0
		 and ' . $queryString . '
		 order by partnerwithdrawalid desc';
        $sqlQuery = new SqlQuery($sql);
//        print_r('<pre>');
//        print_r($sqlQuery);
//                print_r('<pre>');


        return $this->getList($sqlQuery);
    }

    public function queryStringSearch2($queryString) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename, bank.bankname ,bankaccount.accountname
		 FROM partnerwithdrawal
                 JOIN partner ON (partnerwithdrawal.partnerid = partner.partnerid and partner.conditions = 0)
                 left JOIN save ON (partnerwithdrawal.saveid = save.saveid and save.conditions = 0)
                 left JOIN bank ON (bank.bankid = partnerwithdrawal.bankid and bank.conditions = 0)
                 left JOIN bankaccount ON (bankaccount.accountid = partnerwithdrawal.bankaccountid and bankaccount.conditions = 0)
		 where 1 ' . $queryString . ' and partnerwithdrawal.conditions = 0
		 order by partnerwithdrawalid asc';
        $sqlQuery = new SqlQuery($sql);
        //echo $sql;
        return $this->getList($sqlQuery);
    }

    public function loadPartnerwithdrawalById2($partnerwithdrawalid) {
        $sql = 'SELECT partnerwithdrawal.*, partner.partnername, save.savename, bank.bankname ,bankaccount.accountname
		 FROM partnerwithdrawal
                 JOIN partner ON (partnerwithdrawal.partnerid = partner.partnerid and partner.conditions = 0)
                 left JOIN save ON (partnerwithdrawal.saveid = save.saveid and save.conditions = 0)
                 left JOIN bank ON (bank.bankid = partnerwithdrawal.bankid and bank.conditions = 0)
                 left JOIN bankaccount ON (bankaccount.accountid = partnerwithdrawal.bankaccountid and bankaccount.conditions = 0)
		 where partnerwithdrawalid =' . $partnerwithdrawalid . '';
        $sqlQuery = new SqlQuery($sql);
        //echo $sql;
        return $this->getRow($sqlQuery);
    }

}

?>