<?php

/**
 * Class that operate on table 'doctorkashf'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
class DoctorkashfMySqlExtDAO extends DoctorkashfMySqlDAO {

    public function getLastKashfByCustomerId($customerId) {
        $sql = 'SELECT * FROM doctorkashf WHERE customerid = ? order by id desc limit 1';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($customerId);
        return $this->getRow($sqlQuery);
    }

    public function getLastKashfByCustomerIdAndKashfSerial($customerId , $kashfSerial) {
        $sql = 'SELECT * FROM doctorkashf 
                join kashf on kashf.id = doctorkashf.kashfid
                WHERE doctorkashf.customerid = ? and kashf.id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($customerId);
        $sqlQuery->setNumber($kashfSerial);
        return $this->getRow($sqlQuery);
    }
    
    public function querybyDate($queryString) {
        $sql = 'select doctorkashf .*,client.clientname as clientName,user.username as docName
                from doctorkashf
                join client on client.clientid = doctorkashf.customerid
                join user on user.userid = doctorkashf.doctorid
                where ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        // print_r($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllData() {
        $sql = 'select doctorkashf .*,client.clientname as clientName,user.username as docName
                from doctorkashf
                join client on client.clientid = doctorkashf.customerid
                join user on user.userid = doctorkashf.doctorid ';
        $sqlQuery = new SqlQuery($sql);
        // print_r($sql);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchOnly($queryString) {
        $sql = 'select doctorkashf .*,client.clientname as clientName,user.username as docName
                from doctorkashf
                join client on client.clientid = doctorkashf.customerid
                join user on user.userid = doctorkashf.doctorid
                join branch on  branch.branchId = doctorkashf.branchid
                where ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        // print_r($sql);
        return $this->getList($sqlQuery);
    }

    public function queryByRondomtxt($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rondomtxt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getRow($sqlQuery);
    }

}

?>