<?php
/**
 * Class that operate on table 'bindsettlement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 13:42
 */
class BindsettlementMySqlExtDAO extends BindsettlementMySqlDAO{
    public function queryByEmployeeidAndDeleted($employeeId, $deleted) {
        $sql = 'SELECT * FROM bindsettlement WHERE employeeid = ? and deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($employeeId);
        $sqlQuery->setNumber($deleted);
        return $this->getList($sqlQuery);
    }


    public function getLastGroupNo($employeeId) {
        $sql = 'SELECT max(groupno) as groupno FROM bindsettlement WHERE employeeid = ? ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($employeeId);
        return $this->getRow($sqlQuery);
    }

    public function getDistinctGroupNo($employeeId, $deleted) {
        $sql = 'SELECT distinct  groupno FROM bindsettlement where employeeid = ? and deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($employeeId);
        $sqlQuery->setNumber($deleted);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeidAndDeletedAndGroupno($employeeId, $deleted, $groupNo) {
        $sql = 'SELECT * FROM bindsettlement WHERE employeeid = ? and deleted = ? and groupno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($employeeId);
        $sqlQuery->setNumber($deleted);
        $sqlQuery->setNumber($groupNo);
        return $this->getList($sqlQuery);
    }

}
?>