<?php

/**
 * Class that operate on table 'bankaccount'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BankaccountMySqlExtDAO extends BankaccountMySqlDAO {

    public function queryWithOrder() {
        $sql = 'SELECT bankaccount.*, bank.bankname
		 FROM bankaccount JOIN bank
		 ON bankaccount.bankid = bank.bankid
		 where bank.conditions = 0 order by accountid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOrder2ForVisaPayment() {
        $sql = 'SELECT bankaccount.*, bank.bankname
			 FROM bankaccount JOIN bank
			 ON bankaccount.bankid = bank.bankid
			 where bank.conditions = 0 and bankaccount.conditions = 0 and bankaccount.visa = 1
			  order by bankaccount.bankid asc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithBankId($bankid) {
        $sql = 'SELECT bankaccount.*, bank.bankname
		 FROM bankaccount JOIN bank
		 ON bankaccount.bankid = bank.bankid
		 where bank.conditions = 0
		 and  bankaccount.bankid = ' . $bankid . ' order by accountid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryByBankidAndaccountdele($value) {
        $sql = 'SELECT * FROM bankaccount WHERE conditions=0 and bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function updateacount($bankaccount) {
        $sql = 'UPDATE bankaccount SET  accountbeginingbalance = ? WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->set($bankaccount->accountbeginingbalance);


        $sqlQuery->setNumber($bankaccount->accountid);
        return $this->executeUpdate($sqlQuery);
    }

    public function updateAccountbeginingbalance($bankaccount) {
        $sql = 'UPDATE bankaccount SET  accountbeginingbalance = ?, userid = ? WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->set($bankaccount->accountbeginingbalance);
        $sqlQuery->setNumber($bankaccount->userid);

        $sqlQuery->setNumber($bankaccount->accountid);
        return $this->executeUpdate($sqlQuery);
    }

    public function updateAccountbeginingbalance1($accountbeginingbalance, $accountid, $bankid) {

        $sql = 'update bankaccount
                set accountbeginingbalance = "' . $accountbeginingbalance . '"
                where accountid= "' . $accountid . '" and bankid = "' . $bankid . '"';

        $sqlQuery = new SqlQuery($sql);

        //print_r($sqlQuery);

        return $this->executeUpdate($sqlQuery);
    }

    public function updateConditions($bankaccount) {
        $sql = 'UPDATE bankaccount SET  accountdate = ?, userid = ?, conditions = ? WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($bankaccount->accountdate);
        $sqlQuery->setNumber($bankaccount->userid);
        $sqlQuery->setNumber($bankaccount->conditions);

        $sqlQuery->setNumber($bankaccount->accountid);
        return $this->executeUpdate($sqlQuery);
    }

    public function loadBankAccount($accountid) {
        $sql = 'SELECT bankaccount.*, bank.bankname
			 FROM bankaccount JOIN bank
			 ON bankaccount.bankid = bank.bankid
			 where bank.conditions = 0 and bankaccount.accountid = ' . $accountid . '
			 order by accountid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryWithConditons($queryString = '') {
        $sql = 'SELECT bankaccount.*, bank.bankname
			 FROM bankaccount JOIN bank
			 ON bankaccount.bankid = bank.bankid
			 where bank.conditions = 0 and bankaccount.conditions = 0 ' . $queryString . '
			  order by accountid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithConditonsForBalanceReport() {
        $sql = 'SELECT SUM(accountbeginingbalance)
			 FROM bankaccount JOIN bank
			 ON bankaccount.bankid = bank.bankid
			 where bank.conditions = 0 and bankaccount.conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function queryWithConditonsExt() {
        $sql = 'SELECT bankaccount.accountbeginingbalance
			 FROM bankaccount JOIN bank
			 ON bankaccount.bankid = bank.bankid
			 where bank.conditions = 0 and bankaccount.conditions = 0
			  order by accountid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllforbankaccount() {
        $sql = 'SELECT * FROM bankaccount where conditions=0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllByAccNameAndBank($accname, $baknid) {
        $sql = 'SELECT * FROM bankaccount where accountname="' . $accname . '" and bankid=' . $baknid;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllByAccNoAndBank($accno, $baknid) {
        $sql = 'SELECT * FROM bankaccount where accountnumber="' . $accno . '" and bankid=' . $baknid;
        $sqlQuery = new SqlQuery($sql);
        //  print_r($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithBankName() {
        $sql = 'SELECT bankaccount.*, bank.bankname FROM bankaccount,bank where bankaccount.bankid = bank.bankid';
        $sqlQuery = new SqlQuery($sql);
        //  print_r($sql);
        return $this->getList($sqlQuery);
    }

}

?>