<?php

/**
 * Class that operate on table 'temsellandruternbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
class TemsellandruternbilldetailMySqlDAO implements TemsellandruternbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TemsellandruternbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM temsellandruternbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM temsellandruternbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param temsellandruternbilldetail primary key
     */
    public function delete($sellbilldetailid) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TemsellandruternbilldetailMySql temsellandruternbilldetail
     */
    public function insert($temsellandruternbilldetail) {
        $sql = 'INSERT INTO temsellandruternbilldetail (buyprice, parcode, sellbillid, sellbilldetailcatid, sellbilldetailproductid, sellbilldetailquantity, sellbilldetailprice, sellbilldetailtotalprice, discountvalue, note, pricetype, sellbilldetaildate, selltype, productunitid, buydiscount, buydiscounttype, storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellandruternbilldetail->buyprice);
        $sqlQuery->set($temsellandruternbilldetail->parcode);
        $sqlQuery->setNumber($temsellandruternbilldetail->sellbillid);
        $sqlQuery->setNumber($temsellandruternbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($temsellandruternbilldetail->sellbilldetailproductid);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetailquantity);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetailprice);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($temsellandruternbilldetail->discountvalue);
        $sqlQuery->set($temsellandruternbilldetail->note);
        $sqlQuery->setNumber($temsellandruternbilldetail->pricetype);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($temsellandruternbilldetail->selltype);
        $sqlQuery->setNumber($temsellandruternbilldetail->productunitid);
        $sqlQuery->set($temsellandruternbilldetail->buydiscount);
        $sqlQuery->setNumber($temsellandruternbilldetail->buydiscounttype);
        $sqlQuery->setNumber($temsellandruternbilldetail->storeid);

        $id = $this->executeInsert($sqlQuery);
        $temsellandruternbilldetail->sellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TemsellandruternbilldetailMySql temsellandruternbilldetail
     */
    public function update($temsellandruternbilldetail) {
        $sql = 'UPDATE temsellandruternbilldetail SET buyprice = ?, parcode = ?, sellbillid = ?, sellbilldetailcatid = ?, sellbilldetailproductid = ?, sellbilldetailquantity = ?, sellbilldetailprice = ?, sellbilldetailtotalprice = ?, discountvalue = ?, note = ?, pricetype = ?, sellbilldetaildate = ?, selltype = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?, storeid = ? WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellandruternbilldetail->buyprice);
        $sqlQuery->set($temsellandruternbilldetail->parcode);
        $sqlQuery->setNumber($temsellandruternbilldetail->sellbillid);
        $sqlQuery->setNumber($temsellandruternbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($temsellandruternbilldetail->sellbilldetailproductid);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetailquantity);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetailprice);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($temsellandruternbilldetail->discountvalue);
        $sqlQuery->set($temsellandruternbilldetail->note);
        $sqlQuery->setNumber($temsellandruternbilldetail->pricetype);
        $sqlQuery->set($temsellandruternbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($temsellandruternbilldetail->selltype);
        $sqlQuery->setNumber($temsellandruternbilldetail->productunitid);
        $sqlQuery->set($temsellandruternbilldetail->buydiscount);
        $sqlQuery->setNumber($temsellandruternbilldetail->buydiscounttype);
        $sqlQuery->setNumber($temsellandruternbilldetail->storeid);

        $sqlQuery->setNumber($temsellandruternbilldetail->sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM temsellandruternbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailcatid($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailproductid($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailquantity($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailprice($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetaildate($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySelltype($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE selltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitid($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscount($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscounttype($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM temsellandruternbilldetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailcatid($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailproductid($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailquantity($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailprice($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetaildate($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySelltype($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE selltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitid($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscount($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscounttype($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM temsellandruternbilldetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TemsellandruternbilldetailMySql
     */
    protected function readRow($row) {
        $temsellandruternbilldetail = new Temsellandruternbilldetail();

        $temsellandruternbilldetail->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $temsellandruternbilldetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $temsellandruternbilldetail->sellbilldetailid = isset($row['sellbilldetailid']) ? $row['sellbilldetailid'] : '';
        $temsellandruternbilldetail->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $temsellandruternbilldetail->sellbilldetailcatid = isset($row['sellbilldetailcatid']) ? $row['sellbilldetailcatid'] : '';
        $temsellandruternbilldetail->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $temsellandruternbilldetail->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $temsellandruternbilldetail->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $temsellandruternbilldetail->sellbilldetailtotalprice = isset($row['sellbilldetailtotalprice']) ? $row['sellbilldetailtotalprice'] : '';
        $temsellandruternbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $temsellandruternbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $temsellandruternbilldetail->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $temsellandruternbilldetail->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $temsellandruternbilldetail->selltype = isset($row['selltype']) ? $row['selltype'] : '';
        $temsellandruternbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $temsellandruternbilldetail->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $temsellandruternbilldetail->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $temsellandruternbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        return $temsellandruternbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TemsellandruternbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>