<?php

/**
 * Class that operate on table 'temreturnsellbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
class TemreturnsellbillMySqlDAO implements TemreturnsellbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TemreturnsellbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM temreturnsellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM temreturnsellbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param temreturnsellbill primary key
     */
    public function delete($returnsellbillid) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($returnsellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TemreturnsellbillMySql temreturnsellbill
     */
    public function insert($temreturnsellbill) {
        $sql = 'INSERT INTO temreturnsellbill (returnsellbilldate, returnsellbillserial, returnsellbillclientid, returnsellbilltotaldeptbefor, returnsellbilltotaldeptafter, returnsellbilldiscount, returnsellbilldiscounttype, returnsellbilltotalbill, returnsellbillaftertotalbill, returnsellbilltotalpayed, returnsellbillfinalbill, returnsellbillstoreid, returnsellbillsysdate, userid, conditions, returnsellbillclientname, returnsellbillsaveid, returnsellbildirectpayment, billnameid, sellerid, tempclientName, returnsellQuantity, deletedsellid, controlname, tax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temreturnsellbill->returnsellbilldate);
        $sqlQuery->set($temreturnsellbill->returnsellbillserial);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbillclientid);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotaldeptbefor);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotaldeptafter);
        $sqlQuery->set($temreturnsellbill->returnsellbilldiscount);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbilldiscounttype);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotalbill);
        $sqlQuery->set($temreturnsellbill->returnsellbillaftertotalbill);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotalpayed);
        $sqlQuery->set($temreturnsellbill->returnsellbillfinalbill);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbillstoreid);
        $sqlQuery->set($temreturnsellbill->returnsellbillsysdate);
        $sqlQuery->setNumber($temreturnsellbill->userid);
        $sqlQuery->setNumber($temreturnsellbill->conditions);
        $sqlQuery->setString2($temreturnsellbill->returnsellbillclientname);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbillsaveid);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbildirectpayment);
        $sqlQuery->setNumber($temreturnsellbill->billnameid);
        $sqlQuery->setNumber($temreturnsellbill->sellerid);
        $sqlQuery->set($temreturnsellbill->tempclientName);
        $sqlQuery->set($temreturnsellbill->returnsellQuantity);
        $sqlQuery->setNumber($temreturnsellbill->deletedsellid);
        $sqlQuery->set($temreturnsellbill->controlname);
        $sqlQuery->set($temreturnsellbill->tax);

        $id = $this->executeInsert($sqlQuery);
        $temreturnsellbill->returnsellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TemreturnsellbillMySql temreturnsellbill
     */
    public function update($temreturnsellbill) {
        $sql = 'UPDATE temreturnsellbill SET returnsellbilldate = ?, returnsellbillserial = ?, returnsellbillclientid = ?, returnsellbilltotaldeptbefor = ?, returnsellbilltotaldeptafter = ?, returnsellbilldiscount = ?, returnsellbilldiscounttype = ?, returnsellbilltotalbill = ?, returnsellbillaftertotalbill = ?, returnsellbilltotalpayed = ?, returnsellbillfinalbill = ?, returnsellbillstoreid = ?, returnsellbillsysdate = ?, userid = ?, conditions = ?, returnsellbillclientname = ?, returnsellbillsaveid = ?, returnsellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ?, returnsellQuantity = ?, deletedsellid = ?, controlname = ?, tax = ? WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temreturnsellbill->returnsellbilldate);
        $sqlQuery->set($temreturnsellbill->returnsellbillserial);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbillclientid);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotaldeptbefor);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotaldeptafter);
        $sqlQuery->set($temreturnsellbill->returnsellbilldiscount);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbilldiscounttype);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotalbill);
        $sqlQuery->set($temreturnsellbill->returnsellbillaftertotalbill);
        $sqlQuery->set($temreturnsellbill->returnsellbilltotalpayed);
        $sqlQuery->set($temreturnsellbill->returnsellbillfinalbill);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbillstoreid);
        $sqlQuery->set($temreturnsellbill->returnsellbillsysdate);
        $sqlQuery->setNumber($temreturnsellbill->userid);
        $sqlQuery->setNumber($temreturnsellbill->conditions);
        $sqlQuery->setString2($temreturnsellbill->returnsellbillclientname);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbillsaveid);
        $sqlQuery->setNumber($temreturnsellbill->returnsellbildirectpayment);
        $sqlQuery->setNumber($temreturnsellbill->billnameid);
        $sqlQuery->setNumber($temreturnsellbill->sellerid);
        $sqlQuery->set($temreturnsellbill->tempclientName);
        $sqlQuery->set($temreturnsellbill->returnsellQuantity);
        $sqlQuery->setNumber($temreturnsellbill->deletedsellid);
        $sqlQuery->set($temreturnsellbill->controlname);
        $sqlQuery->set($temreturnsellbill->tax);

        $sqlQuery->setNumber($temreturnsellbill->returnsellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM temreturnsellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByReturnsellbilldate($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillserial($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillclientid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldiscount($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldiscounttype($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotalbill($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotalpayed($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillfinalbill($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillstoreid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillsysdate($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillclientname($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillsaveid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbildirectpayment($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempclientName($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellQuantity($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE returnsellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeletedsellid($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControlname($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTax($value) {
        $sql = 'SELECT * FROM temreturnsellbill WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByReturnsellbilldate($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillserial($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillclientid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldiscount($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldiscounttype($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotalbill($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillaftertotalbill($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotalpayed($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillfinalbill($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillstoreid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillsysdate($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillclientname($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillsaveid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbildirectpayment($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempclientName($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellQuantity($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE returnsellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeletedsellid($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControlname($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTax($value) {
        $sql = 'DELETE FROM temreturnsellbill WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TemreturnsellbillMySql
     */
    protected function readRow($row) {
        $temreturnsellbill = new Temreturnsellbill();

        $temreturnsellbill->returnsellbillid = isset($row['returnsellbillid']) ? $row['returnsellbillid'] : '';
        $temreturnsellbill->returnsellbilldate = isset($row['returnsellbilldate']) ? $row['returnsellbilldate'] : '';
        $temreturnsellbill->returnsellbillserial = isset($row['returnsellbillserial']) ? $row['returnsellbillserial'] : '';
        $temreturnsellbill->returnsellbillclientid = isset($row['returnsellbillclientid']) ? $row['returnsellbillclientid'] : '';
        $temreturnsellbill->returnsellbilltotaldeptbefor = isset($row['returnsellbilltotaldeptbefor']) ? $row['returnsellbilltotaldeptbefor'] : '';
        $temreturnsellbill->returnsellbilltotaldeptafter = isset($row['returnsellbilltotaldeptafter']) ? $row['returnsellbilltotaldeptafter'] : '';
        $temreturnsellbill->returnsellbilldiscount = isset($row['returnsellbilldiscount']) ? $row['returnsellbilldiscount'] : '';
        $temreturnsellbill->returnsellbilldiscounttype = isset($row['returnsellbilldiscounttype']) ? $row['returnsellbilldiscounttype'] : '';
        $temreturnsellbill->returnsellbilltotalbill = isset($row['returnsellbilltotalbill']) ? $row['returnsellbilltotalbill'] : '';
        $temreturnsellbill->returnsellbillaftertotalbill = isset($row['returnsellbillaftertotalbill']) ? $row['returnsellbillaftertotalbill'] : '';
        $temreturnsellbill->returnsellbilltotalpayed = isset($row['returnsellbilltotalpayed']) ? $row['returnsellbilltotalpayed'] : '';
        $temreturnsellbill->returnsellbillfinalbill = isset($row['returnsellbillfinalbill']) ? $row['returnsellbillfinalbill'] : '';
        $temreturnsellbill->returnsellbillstoreid = isset($row['returnsellbillstoreid']) ? $row['returnsellbillstoreid'] : '';
        $temreturnsellbill->returnsellbillsysdate = isset($row['returnsellbillsysdate']) ? $row['returnsellbillsysdate'] : '';
        $temreturnsellbill->userid = isset($row['userid']) ? $row['userid'] : '';
        $temreturnsellbill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $temreturnsellbill->returnsellbillclientname = isset($row['returnsellbillclientname']) ? $row['returnsellbillclientname'] : '';
        $temreturnsellbill->returnsellbillsaveid = isset($row['returnsellbillsaveid']) ? $row['returnsellbillsaveid'] : '';
        $temreturnsellbill->returnsellbildirectpayment = isset($row['returnsellbildirectpayment']) ? $row['returnsellbildirectpayment'] : '';
        $temreturnsellbill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $temreturnsellbill->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $temreturnsellbill->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $temreturnsellbill->returnsellQuantity = isset($row['returnsellQuantity']) ? $row['returnsellQuantity'] : '';
        $temreturnsellbill->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $temreturnsellbill->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $temreturnsellbill->tax = isset($row['tax']) ? $row['tax'] : '';

        return $temreturnsellbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TemreturnsellbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>