<?php

/**
 * Class that operate on table 'supplier'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SupplierMySqlDAO implements SupplierDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SupplierMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM supplier WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM supplier';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM supplier ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param supplier primary key
     */
    public function delete($supplierid) {
        $sql = 'DELETE FROM supplier WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($supplierid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SupplierMySql supplier
     */
    public function insert($supplier) {
        $sql = 'INSERT INTO supplier (suppliername, supplieraddress, supplierphone, suppliercurrentDebt, supplierdetails, conditions, userid, supplierdate, dailyentryid, category_id, typesupplier_id,linkedClientId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($supplier->suppliername);
        $sqlQuery->set($supplier->supplieraddress);
        $sqlQuery->set($supplier->supplierphone);
        $sqlQuery->set($supplier->suppliercurrentDebt);
        $sqlQuery->setString2($supplier->supplierdetails);
        $sqlQuery->setNumber($supplier->conditions);
        $sqlQuery->setNumber($supplier->userid);
        $sqlQuery->set($supplier->supplierdate);
        $sqlQuery->setNumber($supplier->dailyentryid);
        $sqlQuery->set($supplier->category_id);
        $sqlQuery->set($supplier->typesupplier_id);
        $sqlQuery->setNumber((int) $supplier->linkedClientId);

        $id = $this->executeInsert($sqlQuery);
        $supplier->supplierid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SupplierMySql supplier
     */
    public function update($supplier) {
        $sql = 'UPDATE supplier SET suppliername = ?, supplieraddress = ?, supplierphone = ?, suppliercurrentDebt = ?, supplierdetails = ?, conditions = ?, userid = ?, supplierdate = ?, dailyentryid = ?, category_id = ?, typesupplier_id = ?,linkedClientId = ? WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($supplier->suppliername);
        $sqlQuery->set($supplier->supplieraddress);
        $sqlQuery->set($supplier->supplierphone);
        $sqlQuery->set($supplier->suppliercurrentDebt);
        $sqlQuery->setString2($supplier->supplierdetails);
        $sqlQuery->setNumber($supplier->conditions);
        $sqlQuery->setNumber($supplier->userid);
        $sqlQuery->set($supplier->supplierdate);
        $sqlQuery->setNumber($supplier->dailyentryid);
        $sqlQuery->set($supplier->category_id);
        $sqlQuery->set($supplier->typesupplier_id);
        $sqlQuery->setNumber((int) $supplier->linkedClientId);

        $sqlQuery->setNumber($supplier->supplierid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM supplier';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySuppliername($value) {
        $sql = 'SELECT * FROM supplier WHERE suppliername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplieraddress($value) {
        $sql = 'SELECT * FROM supplier WHERE supplieraddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierphone($value) {
        $sql = 'SELECT * FROM supplier WHERE supplierphone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySuppliercurrentDebt($value) {
        $sql = 'SELECT * FROM supplier WHERE suppliercurrentDebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdetails($value) {
        $sql = 'SELECT * FROM supplier WHERE supplierdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM supplier WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM supplier WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdate($value) {
        $sql = 'SELECT * FROM supplier WHERE supplierdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySuppliername($value) {
        $sql = 'DELETE FROM supplier WHERE suppliername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplieraddress($value) {
        $sql = 'DELETE FROM supplier WHERE supplieraddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierphone($value) {
        $sql = 'DELETE FROM supplier WHERE supplierphone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySuppliercurrentDebt($value) {
        $sql = 'DELETE FROM supplier WHERE suppliercurrentDebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdetails($value) {
        $sql = 'DELETE FROM supplier WHERE supplierdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM supplier WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM supplier WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdate($value) {
        $sql = 'DELETE FROM supplier WHERE supplierdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SupplierMySql
     */
    protected function readRow($row) {
        $supplier = new Supplier();

        $supplier->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $supplier->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $supplier->supplieraddress = isset($row['supplieraddress']) ? $row['supplieraddress'] : '';
        $supplier->supplierphone = isset($row['supplierphone']) ? $row['supplierphone'] : '';
        $supplier->suppliercurrentDebt = isset($row['suppliercurrentDebt']) ? $row['suppliercurrentDebt'] : '';
        $supplier->supplierdetails = isset($row['supplierdetails']) ? $row['supplierdetails'] : '';
        $supplier->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $supplier->userid = isset($row['userid']) ? $row['userid'] : '';
        $supplier->supplierdate = isset($row['supplierdate']) ? $row['supplierdate'] : '';
        $supplier->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $supplier->category_id = isset($row['category_id']) ? $row['category_id'] : '';
        $supplier->typesupplier_id = isset($row['typesupplier_id']) ? $row['typesupplier_id'] : '';
        $supplier->linkedClientId = isset($row['linkedClientId']) ? $row['linkedClientId'] : '';

        return $supplier;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SupplierMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>