<?php

/**
 * Class that operate on table 'sparepart'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
class SparepartMySqlDAO implements SparepartDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SparepartMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sparepart WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sparepart';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sparepart ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sparepart primary key
     */
    public function delete($sparepartid) {
        $sql = 'DELETE FROM sparepart WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sparepartid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SparepartMySql sparepart
     */
    public function insert($sparepart) {
        $sql = 'INSERT INTO sparepart (sparepartname, sparepartprice, sparepartnotes, userid, sparepartdate, conditions) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sparepart->sparepartname);
        $sqlQuery->set($sparepart->sparepartprice);
        $sqlQuery->setString2($sparepart->sparepartnotes);
        $sqlQuery->setNumber($sparepart->userid);
        $sqlQuery->set($sparepart->sparepartdate);
        $sqlQuery->setNumber($sparepart->conditions);

        $id = $this->executeInsert($sqlQuery);
        $sparepart->sparepartid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SparepartMySql sparepart
     */
    public function update($sparepart) {
        $sql = 'UPDATE sparepart SET sparepartname = ?, sparepartprice = ?, sparepartnotes = ?, userid = ?, sparepartdate = ?, conditions = ? WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sparepart->sparepartname);
        $sqlQuery->set($sparepart->sparepartprice);
        $sqlQuery->setString2($sparepart->sparepartnotes);
        $sqlQuery->setNumber($sparepart->userid);
        $sqlQuery->set($sparepart->sparepartdate);
        $sqlQuery->setNumber($sparepart->conditions);

        $sqlQuery->setNumber($sparepart->sparepartid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sparepart';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySparepartname($value) {
        $sql = 'SELECT * FROM sparepart WHERE sparepartname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySparepartprice($value) {
        $sql = 'SELECT * FROM sparepart WHERE sparepartprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySparepartnotes($value) {
        $sql = 'SELECT * FROM sparepart WHERE sparepartnotes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sparepart WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySparepartdate($value) {
        $sql = 'SELECT * FROM sparepart WHERE sparepartdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM sparepart WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySparepartname($value) {
        $sql = 'DELETE FROM sparepart WHERE sparepartname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySparepartprice($value) {
        $sql = 'DELETE FROM sparepart WHERE sparepartprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySparepartnotes($value) {
        $sql = 'DELETE FROM sparepart WHERE sparepartnotes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sparepart WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySparepartdate($value) {
        $sql = 'DELETE FROM sparepart WHERE sparepartdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM sparepart WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SparepartMySql
     */
    protected function readRow($row) {
        $sparepart = new Sparepart();

        $sparepart->sparepartid = isset($row['sparepartid']) ? $row['sparepartid'] : '';
        $sparepart->sparepartname = isset($row['sparepartname']) ? $row['sparepartname'] : '';
        $sparepart->sparepartprice = isset($row['sparepartprice']) ? $row['sparepartprice'] : '';
        $sparepart->sparepartnotes = isset($row['sparepartnotes']) ? $row['sparepartnotes'] : '';
        $sparepart->userid = isset($row['userid']) ? $row['userid'] : '';
        $sparepart->sparepartdate = isset($row['sparepartdate']) ? $row['sparepartdate'] : '';
        $sparepart->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        //required
        $sparepart->partquantity = isset($row['partquantity']) ? $row['partquantity'] : '';

        return $sparepart;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SparepartMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>