<?php

/**
 * Class that operate on table 'sizecolorstoredetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-08-25 13:50
 */
class SizecolorstoredetailMySqlDAO implements SizecolorstoredetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SizecolorstoredetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sizecolorstoredetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sizecolorstoredetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sizecolorstoredetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SizecolorstoredetailMySql sizecolorstoredetail
     */
    public function insert($sizecolorstoredetail) {
        $sql = 'INSERT INTO sizecolorstoredetail (storeid, productid, sizeid, colorid, buyprice, sellunitprice, quantity, parcode, userid, sysdate, scdExcelParcode) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sizecolorstoredetail->storeid);
        $sqlQuery->setNumber($sizecolorstoredetail->productid);
        $sqlQuery->setNumber($sizecolorstoredetail->sizeid);
        $sqlQuery->setNumber($sizecolorstoredetail->colorid);
        $sqlQuery->set($sizecolorstoredetail->buyprice);
        $sqlQuery->set($sizecolorstoredetail->sellunitprice);
        $sqlQuery->set($sizecolorstoredetail->quantity);
        $sqlQuery->set($sizecolorstoredetail->parcode);
        $sqlQuery->setNumber($sizecolorstoredetail->userid);
        $sqlQuery->set($sizecolorstoredetail->sysdate);
		$sqlQuery->set($sizecolorstoredetail->scdExcelParcode);

        $id = $this->executeInsert($sqlQuery);
        $sizecolorstoredetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SizecolorstoredetailMySql sizecolorstoredetail
     */
    public function update($sizecolorstoredetail) {
        $sql = 'UPDATE sizecolorstoredetail SET storeid = ?, productid = ?, sizeid = ?, colorid = ?, buyprice = ?, sellunitprice = ?, quantity = ?, parcode = ?, userid = ?, sysdate = ?, scdExcelParcode = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sizecolorstoredetail->storeid);
        $sqlQuery->setNumber($sizecolorstoredetail->productid);
        $sqlQuery->setNumber($sizecolorstoredetail->sizeid);
        $sqlQuery->setNumber($sizecolorstoredetail->colorid);
        $sqlQuery->set($sizecolorstoredetail->buyprice);
        $sqlQuery->set($sizecolorstoredetail->sellunitprice);
        $sqlQuery->set($sizecolorstoredetail->quantity);
        $sqlQuery->set($sizecolorstoredetail->parcode);
        $sqlQuery->setNumber($sizecolorstoredetail->userid);
        $sqlQuery->set($sizecolorstoredetail->sysdate);
		$sqlQuery->set($sizecolorstoredetail->scdExcelParcode);

        $sqlQuery->setNumber($sizecolorstoredetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sizecolorstoredetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellunitprice($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE sellunitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM sizecolorstoredetail WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellunitprice($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE sellunitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM sizecolorstoredetail WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SizecolorstoredetailMySql
     */
    protected function readRow($row) {
        $sizecolorstoredetail = new Sizecolorstoredetail();

        $sizecolorstoredetail->id = $row['id'];
        $sizecolorstoredetail->storeid = $row['storeid'];
        $sizecolorstoredetail->productid = $row['productid'];
        $sizecolorstoredetail->sizeid = $row['sizeid'];
        $sizecolorstoredetail->colorid = $row['colorid'];
        $sizecolorstoredetail->buyprice = $row['buyprice'];
        $sizecolorstoredetail->sellunitprice = $row['sellunitprice'];
        $sizecolorstoredetail->quantity = $row['quantity'];
        $sizecolorstoredetail->parcode = $row['parcode'];
        $sizecolorstoredetail->userid = $row['userid'];
        $sizecolorstoredetail->sysdate = $row['sysdate'];
		$sizecolorstoredetail->scdExcelParcode = $row['scdExcelParcode'];
        //
        $sizecolorstoredetail->sizeName = $row['sizeName'];
        $sizecolorstoredetail->colorName = $row['colorName'];
        $sizecolorstoredetail->productName = $row['productName'];
        $sizecolorstoredetail->productCatName = $row['productCatName'];
        $sizecolorstoredetail->productCatId = $row['productCatId'];
        $sizecolorstoredetail->storeName = $row['storeName'];
        $sizecolorstoredetail->productSellUnitPrice = $row['productSellUnitPrice'];
        $sizecolorstoredetail->productBuyPrice = $row['productBuyPrice'];
        $sizecolorstoredetail->lastbuyprice = $row['lastbuyprice'];
        $sizecolorstoredetail->meanbuyprice = $row['meanbuyprice'];
        $sizecolorstoredetail->overAllAveragePrice = $row['overAllAveragePrice'];
        $sizecolorstoredetail->meanbuyprice_withDiscount = $row['meanbuyprice_withDiscount'];
        $sizecolorstoredetail->lastbuyprice_withDiscount = $row['lastbuyprice_withDiscount'];


        return $sizecolorstoredetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SizecolorstoredetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>