<?php

/**
 * Class that operate on table 'simplemanufacturesetting'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-19 11:19
 */
class SimplemanufacturesettingMySqlDAO implements SimplemanufacturesettingDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SimplemanufacturesettingMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM simplemanufacturesetting WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM simplemanufacturesetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM simplemanufacturesetting ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param simplemanufacturesetting primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM simplemanufacturesetting WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SimplemanufacturesettingMySql simplemanufacturesetting
     */
    public function insert($simplemanufacturesetting) {
        $sql = 'INSERT INTO simplemanufacturesetting (storeid, reducestoreamount,productsproductionequation,orderclient,taskOrderName) VALUES (?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($simplemanufacturesetting->storeid);
        $sqlQuery->setNumber($simplemanufacturesetting->reducestoreamount);
        $sqlQuery->setNumber($simplemanufacturesetting->productsproductionequation);
        $sqlQuery->setNumber((int) $simplemanufacturesetting->orderclient);
        $sqlQuery->setNumber((int) $simplemanufacturesetting->taskOrderName);

        $id = $this->executeInsert($sqlQuery);
        $simplemanufacturesetting->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SimplemanufacturesettingMySql simplemanufacturesetting
     */
    public function update($simplemanufacturesetting) {
        $sql = 'UPDATE simplemanufacturesetting SET storeid = ?, reducestoreamount = ?,productsproductionequation = ?, orderclient= ?,taskOrderName=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($simplemanufacturesetting->storeid);
        $sqlQuery->setNumber($simplemanufacturesetting->reducestoreamount);
        $sqlQuery->setNumber($simplemanufacturesetting->productsproductionequation);
        $sqlQuery->setNumber($simplemanufacturesetting->orderclient);
        $sqlQuery->setNumber($simplemanufacturesetting->taskOrderName);

        $sqlQuery->setNumber($simplemanufacturesetting->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM simplemanufacturesetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM simplemanufacturesetting WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReducestoreamount($value) {
        $sql = 'SELECT * FROM simplemanufacturesetting WHERE reducestoreamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM simplemanufacturesetting WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReducestoreamount($value) {
        $sql = 'DELETE FROM simplemanufacturesetting WHERE reducestoreamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SimplemanufacturesettingMySql
     */
    protected function readRow($row) {
        $simplemanufacturesetting = new Simplemanufacturesetting();

        $simplemanufacturesetting->id = $row['id'];
        $simplemanufacturesetting->storeid = $row['storeid'];
        $simplemanufacturesetting->reducestoreamount = $row['reducestoreamount'];
        $simplemanufacturesetting->productsproductionequation = $row['productsproductionequation'];
        $simplemanufacturesetting->orderclient = $row['orderclient'];
        $simplemanufacturesetting->taskOrderName = $row['taskOrderName'];

        return $simplemanufacturesetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SimplemanufacturesettingMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>