<?php

/**
 * Class that operate on table 'sellbillreview'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-05-05 18:38
 */
class SellbillreviewMySqlDAO implements SellbillreviewDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbillreviewMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbillreview WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbillreview';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbillreview ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbillreview primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM sellbillreview WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbillreviewMySql sellbillreview
     */
    public function insert($sellbillreview) {
        $sql = 'INSERT INTO sellbillreview (billid, reviewType, reviewComment, reviewuserid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sellbillreview->billid);
        $sqlQuery->setNumber($sellbillreview->reviewType);
        $sqlQuery->set($sellbillreview->reviewComment);
        $sqlQuery->setNumber($sellbillreview->reviewuserid);
        $sqlQuery->set($sellbillreview->sysdate);
        $sqlQuery->setNumber($sellbillreview->del);

        $id = $this->executeInsert($sqlQuery);
        $sellbillreview->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbillreviewMySql sellbillreview
     */
    public function update($sellbillreview) {
        $sql = 'UPDATE sellbillreview SET billid = ?, reviewType = ?, reviewComment = ?, reviewuserid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sellbillreview->billid);
        $sqlQuery->setNumber($sellbillreview->reviewType);
        $sqlQuery->set($sellbillreview->reviewComment);
        $sqlQuery->setNumber($sellbillreview->reviewuserid);
        $sqlQuery->set($sellbillreview->sysdate);
        $sqlQuery->setNumber($sellbillreview->del);

        $sqlQuery->setNumber($sellbillreview->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbillreview';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM sellbillreview WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReviewType($value) {
        $sql = 'SELECT * FROM sellbillreview WHERE reviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReviewuserid($value) {
        $sql = 'SELECT * FROM sellbillreview WHERE reviewuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM sellbillreview WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM sellbillreview WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM sellbillreview WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReviewType($value) {
        $sql = 'DELETE FROM sellbillreview WHERE reviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReviewuserid($value) {
        $sql = 'DELETE FROM sellbillreview WHERE reviewuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM sellbillreview WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM sellbillreview WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbillreviewMySql
     */
    protected function readRow($row) {
        $sellbillreview = new Sellbillreview();

        $sellbillreview->id = $row['id'];
        $sellbillreview->billid = $row['billid'];
        $sellbillreview->reviewType = $row['reviewType'];
        $sellbillreview->reviewComment = $row['reviewComment'];
        $sellbillreview->reviewuserid = $row['reviewuserid'];
        $sellbillreview->sysdate = $row['sysdate'];
        $sellbillreview->del = $row['del'];
        //
        $sellbillreview->employeename = $row['employeename'];

        return $sellbillreview;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbillreviewMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>