<?php

/**
 * Class that operate on table 'sellbilloffer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-08-24 15:23
 */
class SellbillofferMySqlDAO implements SellbillofferDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbillofferMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbilloffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbilloffer ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbilloffer primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbillofferMySql sellbilloffer
     */
    public function insert($sellbilloffer) {
        $sql = 'INSERT INTO sellbilloffer (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate, comment, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, tempclientName, sellQuantity, deletedsellid, controlname, tax, carnumber, cartype, carchase, carmotor, costcenterid, localdonw, dailyentryid, obygyVisitId, onlineOrderId, delbyuserid, lastReviewType, lastReviewUser, lastReviewDateTime, delivery, totalafterdelivery) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilloffer->sellbilldate);
        $sqlQuery->set($sellbilloffer->sellbillserial);
        $sqlQuery->setNumber($sellbilloffer->sellbillclientid);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptafter);
        $sqlQuery->set($sellbilloffer->sellbilldiscount);
        $sqlQuery->setNumber($sellbilloffer->sellbilldiscounttype);
        $sqlQuery->set($sellbilloffer->sellbilltotalbill);
        $sqlQuery->set($sellbilloffer->sellbillaftertotalbill);
        $sqlQuery->set($sellbilloffer->sellbilltotalpayed);
        $sqlQuery->set($sellbilloffer->sellbillfinalbill);
        $sqlQuery->setNumber($sellbilloffer->sellbillstoreid);
        $sqlQuery->set($sellbilloffer->sellbillsysdate);
        $sqlQuery->setString2($sellbilloffer->comment);
        $sqlQuery->setNumber($sellbilloffer->userid);
        $sqlQuery->setNumber($sellbilloffer->conditions);
        $sqlQuery->setString2($sellbilloffer->sellbillclientname);
        $sqlQuery->setNumber($sellbilloffer->sellbillsaveid);
        $sqlQuery->setNumber($sellbilloffer->sellbildirectpayment);
        $sqlQuery->setNumber($sellbilloffer->billnameid);
        $sqlQuery->setNumber($sellbilloffer->sellerid);
        $sqlQuery->set($sellbilloffer->tempclientName);
        $sqlQuery->set($sellbilloffer->sellQuantity);
        $sqlQuery->setNumber($sellbilloffer->deletedsellid);
        $sqlQuery->set($sellbilloffer->controlname);
        $sqlQuery->set($sellbilloffer->tax);
        $sqlQuery->set($sellbilloffer->carnumber);
        $sqlQuery->set($sellbilloffer->cartype);
        $sqlQuery->set($sellbilloffer->carchase);
        $sqlQuery->set($sellbilloffer->carmotor);
        $sqlQuery->setNumber($sellbilloffer->costcenterid);
        $sqlQuery->setNumber($sellbilloffer->localdonw);
        $sqlQuery->setNumber($sellbilloffer->dailyentryid);
        $sqlQuery->setNumber($sellbilloffer->obygyVisitId);
        $sqlQuery->setNumber($sellbilloffer->onlineOrderId);
        $sqlQuery->setNumber($sellbilloffer->delbyuserid);
        $sqlQuery->setNumber($sellbilloffer->lastReviewType);
        $sqlQuery->setNumber($sellbilloffer->lastReviewUser);
        $sqlQuery->set($sellbilloffer->lastReviewDateTime);
        $sqlQuery->set($sellbilloffer->delivery);
        $sqlQuery->set($sellbilloffer->totalafterdelivery);

        $id = $this->executeInsert($sqlQuery);
        $sellbilloffer->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbillofferMySql sellbilloffer
     */
    public function update($sellbilloffer) {
        $sql = 'UPDATE sellbilloffer SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?, comment = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ?, sellQuantity = ?, deletedsellid = ?, controlname = ?, tax = ?, carnumber = ?, cartype = ?, carchase = ?, carmotor = ?, costcenterid = ?, localdonw = ?, dailyentryid = ?, obygyVisitId = ?, onlineOrderId = ?, delbyuserid = ?, lastReviewType = ?, lastReviewUser = ?, lastReviewDateTime = ?, delivery = ?, totalafterdelivery = ? WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilloffer->sellbilldate);
        $sqlQuery->set($sellbilloffer->sellbillserial);
        $sqlQuery->setNumber($sellbilloffer->sellbillclientid);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptafter);
        $sqlQuery->set($sellbilloffer->sellbilldiscount);
        $sqlQuery->setNumber($sellbilloffer->sellbilldiscounttype);
        $sqlQuery->set($sellbilloffer->sellbilltotalbill);
        $sqlQuery->set($sellbilloffer->sellbillaftertotalbill);
        $sqlQuery->set($sellbilloffer->sellbilltotalpayed);
        $sqlQuery->set($sellbilloffer->sellbillfinalbill);
        $sqlQuery->setNumber($sellbilloffer->sellbillstoreid);
        $sqlQuery->set($sellbilloffer->sellbillsysdate);
        $sqlQuery->setString2($sellbilloffer->comment);
        $sqlQuery->setNumber($sellbilloffer->userid);
        $sqlQuery->setNumber($sellbilloffer->conditions);
        $sqlQuery->setString2($sellbilloffer->sellbillclientname);
        $sqlQuery->setNumber($sellbilloffer->sellbillsaveid);
        $sqlQuery->setNumber($sellbilloffer->sellbildirectpayment);
        $sqlQuery->setNumber($sellbilloffer->billnameid);
        $sqlQuery->setNumber($sellbilloffer->sellerid);
        $sqlQuery->set($sellbilloffer->tempclientName);
        $sqlQuery->set($sellbilloffer->sellQuantity);
        $sqlQuery->setNumber($sellbilloffer->deletedsellid);
        $sqlQuery->set($sellbilloffer->controlname);
        $sqlQuery->set($sellbilloffer->tax);
        $sqlQuery->set($sellbilloffer->carnumber);
        $sqlQuery->set($sellbilloffer->cartype);
        $sqlQuery->set($sellbilloffer->carchase);
        $sqlQuery->set($sellbilloffer->carmotor);
        $sqlQuery->setNumber($sellbilloffer->costcenterid);
        $sqlQuery->setNumber($sellbilloffer->localdonw);
        $sqlQuery->setNumber($sellbilloffer->dailyentryid);
        $sqlQuery->setNumber($sellbilloffer->obygyVisitId);
        $sqlQuery->setNumber($sellbilloffer->onlineOrderId);
        $sqlQuery->setNumber($sellbilloffer->delbyuserid);
        $sqlQuery->setNumber($sellbilloffer->lastReviewType);
        $sqlQuery->setNumber($sellbilloffer->lastReviewUser);
        $sqlQuery->set($sellbilloffer->lastReviewDateTime);
        $sqlQuery->set($sellbilloffer->delivery);
        $sqlQuery->set($sellbilloffer->totalafterdelivery);

        $sqlQuery->setNumber($sellbilloffer->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbilloffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempclientName($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellQuantity($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeletedsellid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControlname($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTax($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCarnumber($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE carnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCartype($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE cartype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCarchase($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE carchase = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCarmotor($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE carmotor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLocaldonw($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE localdonw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByObygyVisitId($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE obygyVisitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOnlineOrderId($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE onlineOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelbyuserid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE delbyuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastReviewType($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE lastReviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastReviewUser($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE lastReviewUser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastReviewDateTime($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE lastReviewDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelivery($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE delivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalafterdelivery($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE totalafterdelivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempclientName($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellQuantity($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeletedsellid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControlname($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTax($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCarnumber($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE carnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCartype($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE cartype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCarchase($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE carchase = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCarmotor($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE carmotor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLocaldonw($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE localdonw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByObygyVisitId($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE obygyVisitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOnlineOrderId($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE onlineOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelbyuserid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE delbyuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastReviewType($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE lastReviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastReviewUser($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE lastReviewUser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastReviewDateTime($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE lastReviewDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelivery($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE delivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalafterdelivery($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE totalafterdelivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbillofferMySql
     */
    protected function readRow($row) {
        $sellbilloffer = new Sellbilloffer();

        $sellbilloffer->sellbillid = $row['sellbillid'];
        $sellbilloffer->sellbilldate = $row['sellbilldate'];
        $sellbilloffer->sellbillserial = $row['sellbillserial'];
        $sellbilloffer->sellbillclientid = $row['sellbillclientid'];
        $sellbilloffer->sellbilltotaldeptbefor = $row['sellbilltotaldeptbefor'];
        $sellbilloffer->sellbilltotaldeptafter = $row['sellbilltotaldeptafter'];
        $sellbilloffer->sellbilldiscount = $row['sellbilldiscount'];
        $sellbilloffer->sellbilldiscounttype = $row['sellbilldiscounttype'];
        $sellbilloffer->sellbilltotalbill = $row['sellbilltotalbill'];
        $sellbilloffer->sellbillaftertotalbill = $row['sellbillaftertotalbill'];
        $sellbilloffer->sellbilltotalpayed = $row['sellbilltotalpayed'];
        $sellbilloffer->sellbillfinalbill = $row['sellbillfinalbill'];
        $sellbilloffer->sellbillstoreid = $row['sellbillstoreid'];
        $sellbilloffer->sellbillsysdate = $row['sellbillsysdate'];
        $sellbilloffer->comment = $row['comment'];
        $sellbilloffer->userid = $row['userid'];
        $sellbilloffer->conditions = $row['conditions'];
        $sellbilloffer->sellbillclientname = $row['sellbillclientname'];
        $sellbilloffer->sellbillsaveid = $row['sellbillsaveid'];
        $sellbilloffer->sellbildirectpayment = $row['sellbildirectpayment'];
        $sellbilloffer->billnameid = $row['billnameid'];
        $sellbilloffer->sellerid = $row['sellerid'];
        $sellbilloffer->tempclientName = $row['tempclientName'];
        $sellbilloffer->sellQuantity = $row['sellQuantity'];
        $sellbilloffer->deletedsellid = $row['deletedsellid'];
        $sellbilloffer->controlname = $row['controlname'];
        $sellbilloffer->tax = $row['tax'];
        $sellbilloffer->carnumber = $row['carnumber'];
        $sellbilloffer->cartype = $row['cartype'];
        $sellbilloffer->carchase = $row['carchase'];
        $sellbilloffer->carmotor = $row['carmotor'];
        $sellbilloffer->costcenterid = $row['costcenterid'];
        $sellbilloffer->localdonw = $row['localdonw'];
        $sellbilloffer->dailyentryid = $row['dailyentryid'];
        $sellbilloffer->obygyVisitId = $row['obygyVisitId'];
        $sellbilloffer->onlineOrderId = $row['onlineOrderId'];
        $sellbilloffer->delbyuserid = $row['delbyuserid'];
        $sellbilloffer->lastReviewType = $row['lastReviewType'];
        $sellbilloffer->lastReviewUser = $row['lastReviewUser'];
        $sellbilloffer->lastReviewDateTime = $row['lastReviewDateTime'];
        $sellbilloffer->delivery = $row['delivery'];
        $sellbilloffer->totalafterdelivery = $row['totalafterdelivery'];
        $sellbilloffer->orderSavedBillId = $row['orderSavedBillId'];
        //
        $sellbilloffer->clientname = $row['clientname'];
        $sellbilloffer->employeename = $row['employeename'];
        $sellbilloffer->useremployeename = $row['useremployeename'];
        $sellbilloffer->storeName = $row['storeName'];

        return $sellbilloffer;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbillofferMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>