<?php

/**
 * Class that operate on table 'sellbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SellbilldetailMySqlDAO implements SellbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbilldetail primary key
     */
    public function delete($sellbilldetailid) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbilldetailMySql sellbilldetail
     */
    public function insert($sellbilldetail) {
        $sql = 'INSERT INTO sellbilldetail (buyprice, parcode, sellbillid, sellbilldetailcatid, '
                . 'sellbilldetailproductid, sellbilldetailquantity, sellbilldetailprice, sellbilldetailtotalprice, '
                . 'discountvalue, note, pricetype, sellbilldetaildate, productunitid, buydiscount, buydiscounttype,'
                . 'storeid,discounttype,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount,otherdetailquantity,sizeid,colorid,onlineOrderId,pricetypepro,playstationPlayId,soldSerialsInDetails,buyPricesHistoryBookIdQuantity) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilldetail->buyprice);
        $sqlQuery->set($sellbilldetail->parcode);
        $sqlQuery->setNumber($sellbilldetail->sellbillid);
        $sqlQuery->setNumber($sellbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($sellbilldetail->sellbilldetailproductid);
        $sqlQuery->setNumber($sellbilldetail->sellbilldetailquantity);
        $sqlQuery->set($sellbilldetail->sellbilldetailprice);
        $sqlQuery->set($sellbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($sellbilldetail->discountvalue);
        $sqlQuery->set($sellbilldetail->note);
        $sqlQuery->setNumber($sellbilldetail->pricetype);
        $sqlQuery->set($sellbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($sellbilldetail->productunitid);
        $sqlQuery->setNumber($sellbilldetail->buydiscount);
        $sqlQuery->setNumber($sellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($sellbilldetail->storeid);

        $sqlQuery->set($sellbilldetail->discounttype);
        $sqlQuery->set($sellbilldetail->lastbuyprice);
        $sqlQuery->set($sellbilldetail->meanbuyprice);
        $sqlQuery->set((float) $sellbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $sellbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $sellbilldetail->otherdetailquantity);
        $sqlQuery->setNumber((int) $sellbilldetail->sizeid);
        $sqlQuery->setNumber((int) $sellbilldetail->colorid);
        $sqlQuery->setNumber((int) $sellbilldetail->onlineOrderId);
        $sqlQuery->setNumber((int) $sellbilldetail->pricetypepro);
        $sqlQuery->setNumber((int) $sellbilldetail->playstationPlayId);
        $sqlQuery->set($sellbilldetail->soldSerialsInDetails);
        $sqlQuery->set($sellbilldetail->buyPricesHistoryBookIdQuantity);


        $id = $this->executeInsert($sqlQuery);
        $sellbilldetail->sellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbilldetailMySql sellbilldetail
     */
    public function update($sellbilldetail) {
        $sql = 'UPDATE sellbilldetail SET buyprice = ?, parcode = ?, sellbillid = ?, sellbilldetailcatid = ?, sellbilldetailproductid = ?, sellbilldetailquantity = ?, sellbilldetailprice = ?, sellbilldetailtotalprice = ?, discountvalue = ?, note = ?, pricetype = ?, sellbilldetaildate = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?
		,storeid = ?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?,sizeid = ?,colorid = ?,onlineOrderId = ?,pricetypepro = ?,playstationPlayId=?,soldSerialsInDetails=? WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilldetail->buyprice);
        $sqlQuery->set($sellbilldetail->parcode);
        $sqlQuery->setNumber($sellbilldetail->sellbillid);
        $sqlQuery->setNumber($sellbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($sellbilldetail->sellbilldetailproductid);
        $sqlQuery->setNumber($sellbilldetail->sellbilldetailquantity);
        $sqlQuery->set($sellbilldetail->sellbilldetailprice);
        $sqlQuery->set($sellbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($sellbilldetail->discountvalue);
        $sqlQuery->set($sellbilldetail->note);
        $sqlQuery->setNumber($sellbilldetail->pricetype);
        $sqlQuery->set($sellbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($sellbilldetail->productunitid);
        $sqlQuery->setNumber($sellbilldetail->buydiscount);
        $sqlQuery->setNumber($sellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($sellbilldetail->storeid);
        $sqlQuery->set($sellbilldetail->lastbuyprice);
        $sqlQuery->set($sellbilldetail->meanbuyprice);
        $sqlQuery->set((float) $sellbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $sellbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $sellbilldetail->sizeid);
        $sqlQuery->setNumber((int) $sellbilldetail->colorid);
        $sqlQuery->setNumber((int) $sellbilldetail->onlineOrderId);
        $sqlQuery->setNumber((int) $sellbilldetail->pricetypepro);
        $sqlQuery->setNumber((int) $sellbilldetail->playstationPlayId);
        $sqlQuery->set($sellbilldetail->soldSerialsInDetails);

        $sqlQuery->setNumber($sellbilldetail->sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailcatid($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailproductid($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailquantity($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailprice($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM sellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailcatid($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailproductid($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailquantity($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailprice($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM sellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbilldetailMySql
     */
    protected function readRow($row) {
        $sellbilldetail = new Sellbilldetail();

        $sellbilldetail->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $sellbilldetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $sellbilldetail->sellbilldetailid = isset($row['sellbilldetailid']) ? $row['sellbilldetailid'] : '';
        $sellbilldetail->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $sellbilldetail->sellbilldetailcatid = isset($row['sellbilldetailcatid']) ? $row['sellbilldetailcatid'] : '';
        $sellbilldetail->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $sellbilldetail->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $sellbilldetail->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $sellbilldetail->sellbilldetailtotalprice = isset($row['sellbilldetailtotalprice']) ? $row['sellbilldetailtotalprice'] : '';
        $sellbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $sellbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $sellbilldetail->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $sellbilldetail->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $sellbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $sellbilldetail->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $sellbilldetail->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $sellbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $sellbilldetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';

        $sellbilldetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $sellbilldetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $sellbilldetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $sellbilldetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $sellbilldetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $sellbilldetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $sellbilldetail->onlineOrderId = isset($row['onlineOrderId']) ? $row['onlineOrderId'] : '';
        $sellbilldetail->pricetypepro = isset($row['pricetypepro']) ? $row['pricetypepro'] : '';
        $sellbilldetail->playstationPlayId = isset($row['playstationPlayId']) ? $row['playstationPlayId'] : '';
        $sellbilldetail->soldSerialsInDetails = isset($row['soldSerialsInDetails']) ? $row['soldSerialsInDetails'] : '';
        $sellbilldetail->buyPricesHistoryBookIdQuantity = isset($row['buyPricesHistoryBookIdQuantity']) ? $row['buyPricesHistoryBookIdQuantity'] : '';
        //required
        $sellbilldetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $sellbilldetail->totQty = isset($row['totQty']) ? $row['totQty'] : '';
        $sellbilldetail->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $sellbilldetail->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $sellbilldetail->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $sellbilldetail->productid = isset($row['productid']) ? $row['productid'] : '';
        $sellbilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $sellbilldetail->startsysDate = isset($row['startsysDate']) ? $row['startsysDate'] : '';
        $sellbilldetail->endsysDate = isset($row['endsysDate']) ? $row['endsysDate'] : '';
        $sellbilldetail->moveStartSysDate = isset($row['moveStartSysDate']) ? $row['moveStartSysDate'] : '';
        $sellbilldetail->priceIs = isset($row['priceIs']) ? $row['priceIs'] : '';


        $sellbilldetail->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $sellbilldetail->selldate = isset($row['selldate']) ? $row['selldate'] : '';
        $sellbilldetail->price = isset($row['price']) ? $row['price'] : '';
        $sellbilldetail->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';

        $sellbilldetail->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $sellbilldetail->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $sellbilldetail->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $sellbilldetail->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $sellbilldetail->limitamount = isset($row['limitamount']) ? $row['limitamount'] : '';
        $sellbilldetail->productquantity = isset($row['productquantity']) ? $row['productquantity'] : '';
        $sellbilldetail->otherdetailquantity = isset($row['otherdetailquantity']) ? $row['otherdetailquantity'] : '';



        //req nora

        $sellbilldetail->controlnname = isset($row['controlnname']) ? $row['controlnname'] : '';
        $sellbilldetail->sellid = isset($row['sellid']) ? $row['sellid'] : '';
        $sellbilldetail->type = isset($row['type']) ? $row['type'] : '';
        $sellbilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $sellbilldetail->billtype = isset($row['billtype']) ? $row['billtype'] : '';
        $sellbilldetail->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $sellbilldetail->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $sellbilldetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        $sellbilldetail->userid = isset($row['userid']) ? $row['userid'] : '';

        $sellbilldetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $sellbilldetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $sellbilldetail->generalPrice = isset($row['generalPrice']) ? $row['generalPrice'] : '';
        $sellbilldetail->productserailid = isset($row['productserailid']) ? $row['productserailid'] : '';
        $sellbilldetail->don = isset($row['don']) ? $row['don'] : '';
        $sellbilldetail->productParcode = isset($row['productParcode']) ? $row['productParcode'] : '';
        $sellbilldetail->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';


        return $sellbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>