<?php

/**
 * Class that operate on table 'sellandruternbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-29 13:54
 */
class SellandruternbilldetailMySqlDAO implements SellandruternbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellandruternbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellandruternbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellandruternbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellandruternbilldetail primary key
     */
    public function delete($sellbilldetailid) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellandruternbilldetailMySql sellandruternbilldetail
     */
    public function insert($sellandruternbilldetail) {
        $sql = 'INSERT INTO sellandruternbilldetail (buyprice, parcode, sellbillid, sellbilldetailcatid,'
                . ' sellbilldetailproductid, sellbilldetailquantity, sellbilldetailprice, sellbilldetailtotalprice, '
                . 'discountvalue, note, pricetype, sellbilldetaildate, selltype, productunitid, buydiscount,'
                . ' buydiscounttype,storeid,discounttype,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount,otherdetailquantity,sizeid,colorid,pricetypepro,buyPricesHistoryBookIdQuantity) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellandruternbilldetail->buyprice);
        $sqlQuery->set($sellandruternbilldetail->parcode);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbillid);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailproductid);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailquantity);
        $sqlQuery->set($sellandruternbilldetail->sellbilldetailprice);
        $sqlQuery->set($sellandruternbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($sellandruternbilldetail->discountvalue);
        $sqlQuery->set($sellandruternbilldetail->note);
        $sqlQuery->setNumber($sellandruternbilldetail->pricetype);
        $sqlQuery->set($sellandruternbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($sellandruternbilldetail->selltype);
        $sqlQuery->setNumber($sellandruternbilldetail->productunitid);
        $sqlQuery->setNumber($sellandruternbilldetail->buydiscount);
        $sqlQuery->setNumber($sellandruternbilldetail->buydiscounttype);
        $sqlQuery->setNumber($sellandruternbilldetail->storeid);
        $sqlQuery->set($sellandruternbilldetail->discounttype);

        $sqlQuery->set($sellandruternbilldetail->lastbuyprice);
        $sqlQuery->set($sellandruternbilldetail->meanbuyprice);
        $sqlQuery->set((float) $sellandruternbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $sellandruternbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber($sellandruternbilldetail->otherdetailquantity);
        $sqlQuery->setNumber((int) $sellandruternbilldetail->sizeid);
        $sqlQuery->setNumber((int) $sellandruternbilldetail->colorid);
        $sqlQuery->setNumber((int) $sellandruternbilldetail->pricetypepro);
        $sqlQuery->set($sellandruternbilldetail->buyPricesHistoryBookIdQuantity);

        $id = $this->executeInsert($sqlQuery);
        $sellandruternbilldetail->sellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellandruternbilldetailMySql sellandruternbilldetail
     */
    public function update($sellandruternbilldetail) {
        $sql = 'UPDATE sellandruternbilldetail SET buyprice = ?, parcode = ?, sellbillid = ?, sellbilldetailcatid = ?, sellbilldetailproductid = ?, sellbilldetailquantity = ?, sellbilldetailprice = ?, sellbilldetailtotalprice = ?, discountvalue = ?, note = ?, pricetype = ?, sellbilldetaildate = ?, selltype = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?,sizeid = ?,colorid = ?,pricetypepro = ? WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellandruternbilldetail->buyprice);
        $sqlQuery->set($sellandruternbilldetail->parcode);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbillid);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailproductid);
        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailquantity);
        $sqlQuery->set($sellandruternbilldetail->sellbilldetailprice);
        $sqlQuery->set($sellandruternbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($sellandruternbilldetail->discountvalue);
        $sqlQuery->set($sellandruternbilldetail->note);
        $sqlQuery->setNumber($sellandruternbilldetail->pricetype);
        $sqlQuery->set($sellandruternbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($sellandruternbilldetail->selltype);
        $sqlQuery->setNumber($sellandruternbilldetail->productunitid);
        $sqlQuery->setNumber($sellandruternbilldetail->buydiscount);
        $sqlQuery->setNumber($sellandruternbilldetail->buydiscounttype);
        $sqlQuery->set($sellandruternbilldetail->lastbuyprice);
        $sqlQuery->set($sellandruternbilldetail->meanbuyprice);
        $sqlQuery->set((float) $sellandruternbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $sellandruternbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $sellandruternbilldetail->sizeid);
        $sqlQuery->setNumber((int) $sellandruternbilldetail->colorid);
        $sqlQuery->setNumber((int) $sellandruternbilldetail->pricetypepro);

        $sqlQuery->setNumber($sellandruternbilldetail->sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellandruternbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailcatid($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailproductid($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailquantity($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailprice($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetaildate($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySelltype($value) {
        $sql = 'SELECT * FROM sellandruternbilldetail WHERE selltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailcatid($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailproductid($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailquantity($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailprice($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetaildate($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySelltype($value) {
        $sql = 'DELETE FROM sellandruternbilldetail WHERE selltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellandruternbilldetailMySql
     */
    protected function readRow($row) {
        $sellandruternbilldetail = new Sellandruternbilldetail();

        $sellandruternbilldetail->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $sellandruternbilldetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $sellandruternbilldetail->sellbilldetailid = isset($row['sellbilldetailid']) ? $row['sellbilldetailid'] : '';
        $sellandruternbilldetail->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $sellandruternbilldetail->sellbilldetailcatid = isset($row['sellbilldetailcatid']) ? $row['sellbilldetailcatid'] : '';
        $sellandruternbilldetail->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $sellandruternbilldetail->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $sellandruternbilldetail->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $sellandruternbilldetail->sellbilldetailtotalprice = isset($row['sellbilldetailtotalprice']) ? $row['sellbilldetailtotalprice'] : '';
        $sellandruternbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $sellandruternbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $sellandruternbilldetail->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $sellandruternbilldetail->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $sellandruternbilldetail->selltype = isset($row['selltype']) ? $row['selltype'] : '';
        $sellandruternbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $sellandruternbilldetail->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $sellandruternbilldetail->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $sellandruternbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $sellandruternbilldetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';

        $sellandruternbilldetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $sellandruternbilldetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $sellandruternbilldetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $sellandruternbilldetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $sellandruternbilldetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $sellandruternbilldetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $sellandruternbilldetail->pricetypepro = isset($row['pricetypepro']) ? $row['pricetypepro'] : '';
        $sellandruternbilldetail->buyPricesHistoryBookIdQuantity = isset($row['buyPricesHistoryBookIdQuantity']) ? $row['buyPricesHistoryBookIdQuantity'] : '';


        //required
        $sellandruternbilldetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $sellandruternbilldetail->totQty = isset($row['totQty']) ? $row['totQty'] : '';
        $sellandruternbilldetail->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $sellandruternbilldetail->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $sellandruternbilldetail->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $sellandruternbilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $sellandruternbilldetail->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $sellandruternbilldetail->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';

        $sellandruternbilldetail->sellbillprice = isset($row['sellbillprice']) ? $row['sellbillprice'] : '';
        $sellandruternbilldetail->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $sellandruternbilldetail->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $sellandruternbilldetail->totalQTY = isset($row['totalQTY']) ? $row['totalQTY'] : '';
        $sellandruternbilldetail->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $sellandruternbilldetail->returnsellbillprice = isset($row['returnsellbillprice']) ? $row['returnsellbillprice'] : '';
        $sellandruternbilldetail->billtype = isset($row['billtype']) ? $row['billtype'] : '';
        $sellandruternbilldetail->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $sellandruternbilldetail->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $sellandruternbilldetail->otherdetailquantity = isset($row['otherdetailquantity']) ? $row['otherdetailquantity'] : '';
        $sellandruternbilldetail->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $sellandruternbilldetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        $sellandruternbilldetail->userid = isset($row['userid']) ? $row['userid'] : '';
        $sellandruternbilldetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $sellandruternbilldetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $sellandruternbilldetail->generalPrice = isset($row['generalPrice']) ? $row['generalPrice'] : '';
        $sellandruternbilldetail->productserailid = isset($row['productserailid']) ? $row['productserailid'] : '';
        $sellandruternbilldetail->don = isset($row['don']) ? $row['don'] : '';

        return $sellandruternbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellandruternbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>