<?php

/**
 * Class that operate on table 'savedaily'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SavedailyMySqlDAO implements SavedailyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SavedailyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM savedaily WHERE savedailyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM savedaily';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM savedaily ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param savedaily primary key
     */
    public function delete($savedailyid) {
        $sql = 'DELETE FROM savedaily WHERE savedailyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($savedailyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SavedailyMySql savedaily
     */
    public function insert($savedaily) {
        $sql = 'INSERT INTO savedaily (savedailysavebefore, savedailychangeamount, savedailychangetype, saveid, processname, savedailymodelid, savedailysaveafter, savedailydate, userid, tablename,clientid ,note) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?,  ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($savedaily->savedailysavebefore);
        $sqlQuery->set($savedaily->savedailychangeamount);
        $sqlQuery->setNumber($savedaily->savedailychangetype);
        $sqlQuery->setNumber($savedaily->saveid);
        $sqlQuery->set($savedaily->processname);
        $sqlQuery->setNumber($savedaily->savedailymodelid);
        $sqlQuery->set($savedaily->savedailysaveafter);
        $sqlQuery->set($savedaily->savedailydate);
        $sqlQuery->setNumber($savedaily->userid);
        $sqlQuery->set($savedaily->tablename);
        if (!isset($savedaily->clientid) || empty($savedaily->clientid)) {
            $savedaily->clientid = 0;
        }
        $sqlQuery->setNumber($savedaily->clientid);
        $sqlQuery->set($savedaily->note);

        $id = $this->executeInsert($sqlQuery);
        $savedaily->savedailyid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SavedailyMySql savedaily
     */
    public function update($savedaily) {
        $sql = 'UPDATE savedaily SET savedailysavebefore = ?, savedailychangeamount = ?, savedailychangetype = ?, saveid = ?, processname = ?, savedailymodelid = ?, savedailysaveafter = ?, savedailydate = ?, userid = ?, tablename = ? , clientid = ?,note = ? WHERE savedailyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($savedaily->savedailysavebefore);
        $sqlQuery->set($savedaily->savedailychangeamount);
        $sqlQuery->setNumber($savedaily->savedailychangetype);
        $sqlQuery->setNumber($savedaily->saveid);
        $sqlQuery->set($savedaily->processname);
        $sqlQuery->setNumber($savedaily->savedailymodelid);
        $sqlQuery->set($savedaily->savedailysaveafter);
        $sqlQuery->set($savedaily->savedailydate);
        $sqlQuery->setNumber($savedaily->userid);
        $sqlQuery->set($savedaily->tablename);
        $sqlQuery->setNumber($savedaily->clientid);
        $sqlQuery->set($savedaily->note);

        $sqlQuery->setNumber($savedaily->savedailyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM savedaily';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySavedailysavebefore($value) {
        $sql = 'SELECT * FROM savedaily WHERE savedailysavebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedailychangeamount($value) {
        $sql = 'SELECT * FROM savedaily WHERE savedailychangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedailychangetype($value) {
        $sql = 'SELECT * FROM savedaily WHERE savedailychangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM savedaily WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM savedaily WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedailymodelid($value) {
        $sql = 'SELECT * FROM savedaily WHERE savedailymodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedailysaveafter($value) {
        $sql = 'SELECT * FROM savedaily WHERE savedailysaveafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedailydate($value) {
        $sql = 'SELECT * FROM savedaily WHERE savedailydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM savedaily WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM savedaily WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySavedailysavebefore($value) {
        $sql = 'DELETE FROM savedaily WHERE savedailysavebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedailychangeamount($value) {
        $sql = 'DELETE FROM savedaily WHERE savedailychangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedailychangetype($value) {
        $sql = 'DELETE FROM savedaily WHERE savedailychangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM savedaily WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM savedaily WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedailymodelid($value) {
        $sql = 'DELETE FROM savedaily WHERE savedailymodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedailysaveafter($value) {
        $sql = 'DELETE FROM savedaily WHERE savedailysaveafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedailydate($value) {
        $sql = 'DELETE FROM savedaily WHERE savedailydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM savedaily WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM savedaily WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SavedailyMySql
     */
    protected function readRow($row) {
        $savedaily = new Savedaily();

        $savedaily->savedailyid = isset($row['savedailyid']) ? $row['savedailyid'] : '';
        $savedaily->savedailysavebefore = isset($row['savedailysavebefore']) ? $row['savedailysavebefore'] : '';
        $savedaily->savedailychangeamount = isset($row['savedailychangeamount']) ? $row['savedailychangeamount'] : '';
        $savedaily->savedailychangetype = isset($row['savedailychangetype']) ? $row['savedailychangetype'] : '';
        $savedaily->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $savedaily->processname = isset($row['processname']) ? $row['processname'] : '';
        $savedaily->savedailymodelid = isset($row['savedailymodelid']) ? $row['savedailymodelid'] : '';
        $savedaily->savedailysaveafter = isset($row['savedailysaveafter']) ? $row['savedailysaveafter'] : '';
        $savedaily->savedailydate = isset($row['savedailydate']) ? $row['savedailydate'] : '';
        $savedaily->userid = isset($row['userid']) ? $row['userid'] : '';
        $savedaily->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $savedaily->finalstring = isset($row['finalstring']) ? $row['finalstring'] : '';


        //required
        $savedaily->savename = isset($row['savename']) ? $row['savename'] : '';
        $savedaily->savecurrentvalue = isset($row['savecurrentvalue']) ? $row['savecurrentvalue'] : '';
        $savedaily->link = isset($row['link']) ? $row['link'] : '';
        $savedaily->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $savedaily->username = isset($row['username']) ? $row['username'] : '';
        $savedaily->note = isset($row['note']) ? $row['note'] : '';


        return $savedaily;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SavedailyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>