<?php

/**
 * Class that operate on table 'returnsellbillreview'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-05-05 18:38
 */
class ReturnsellbillreviewMySqlDAO implements ReturnsellbillreviewDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ReturnsellbillreviewMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM returnsellbillreview WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM returnsellbillreview';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM returnsellbillreview ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param returnsellbillreview primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM returnsellbillreview WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ReturnsellbillreviewMySql returnsellbillreview
     */
    public function insert($returnsellbillreview) {
        $sql = 'INSERT INTO returnsellbillreview (billid, reviewType, reviewComment, reviewuserid, sysdate, del) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($returnsellbillreview->billid);
        $sqlQuery->setNumber($returnsellbillreview->reviewType);
        $sqlQuery->set($returnsellbillreview->reviewComment);
        $sqlQuery->setNumber($returnsellbillreview->reviewuserid);
        $sqlQuery->set($returnsellbillreview->sysdate);
        $sqlQuery->setNumber($returnsellbillreview->del);

        $id = $this->executeInsert($sqlQuery);
        $returnsellbillreview->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ReturnsellbillreviewMySql returnsellbillreview
     */
    public function update($returnsellbillreview) {
        $sql = 'UPDATE returnsellbillreview SET billid = ?, reviewType = ?, reviewComment = ?, reviewuserid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($returnsellbillreview->billid);
        $sqlQuery->setNumber($returnsellbillreview->reviewType);
        $sqlQuery->set($returnsellbillreview->reviewComment);
        $sqlQuery->setNumber($returnsellbillreview->reviewuserid);
        $sqlQuery->set($returnsellbillreview->sysdate);
        $sqlQuery->setNumber($returnsellbillreview->del);

        $sqlQuery->setNumber($returnsellbillreview->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM returnsellbillreview';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM returnsellbillreview WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReviewType($value) {
        $sql = 'SELECT * FROM returnsellbillreview WHERE reviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReviewuserid($value) {
        $sql = 'SELECT * FROM returnsellbillreview WHERE reviewuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM returnsellbillreview WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM returnsellbillreview WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM returnsellbillreview WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReviewType($value) {
        $sql = 'DELETE FROM returnsellbillreview WHERE reviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReviewuserid($value) {
        $sql = 'DELETE FROM returnsellbillreview WHERE reviewuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM returnsellbillreview WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM returnsellbillreview WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ReturnsellbillreviewMySql
     */
    protected function readRow($row) {
        $returnsellbillreview = new Returnsellbillreview();

        $returnsellbillreview->id = $row['id'];
        $returnsellbillreview->billid = $row['billid'];
        $returnsellbillreview->reviewType = $row['reviewType'];
        $returnsellbillreview->reviewComment = $row['reviewComment'];
        $returnsellbillreview->reviewuserid = $row['reviewuserid'];
        $returnsellbillreview->sysdate = $row['sysdate'];
        $returnsellbillreview->del = $row['del'];
        //
        $returnsellbillreview->employeename = $row['employeename'];

        return $returnsellbillreview;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ReturnsellbillreviewMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>