<?php

/**
 * Class that operate on table 'restaurantrawdestruction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-22 14:34
 */
class RestaurantrawdestructionMySqlDAO implements RestaurantrawdestructionDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantrawdestructionMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantrawdestruction';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantrawdestruction ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantrawdestruction primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantrawdestructionMySql restaurantrawdestruction
     */
    public function insert($restaurantrawdestruction) {
        $sql = 'INSERT INTO restaurantrawdestruction (storeid, productid, quantity,productBuyPrice,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount, conditions, sysdate, userid) VALUES (?, ?, ?, ?, ?, ?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantrawdestruction->storeid);
        $sqlQuery->setNumber($restaurantrawdestruction->productid);
        $sqlQuery->setNumber($restaurantrawdestruction->quantity);
        $sqlQuery->setNumber($restaurantrawdestruction->productBuyPrice);
        $sqlQuery->setNumber($restaurantrawdestruction->lastbuyprice);
        $sqlQuery->setNumber($restaurantrawdestruction->meanbuyprice);
        $sqlQuery->setNumber((float) $restaurantrawdestruction->lastbuyprice_withDiscount);
        $sqlQuery->setNumber((float) $restaurantrawdestruction->meanbuyprice_withDiscount);
        $sqlQuery->setNumber($restaurantrawdestruction->conditions);
        $sqlQuery->set($restaurantrawdestruction->sysdate);
        $sqlQuery->setNumber($restaurantrawdestruction->userid);

        $id = $this->executeInsert($sqlQuery);
        $restaurantrawdestruction->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantrawdestructionMySql restaurantrawdestruction
     */
    public function update($restaurantrawdestruction) {
        $sql = 'UPDATE restaurantrawdestruction SET storeid = ?, productid = ?, quantity = ?,productBuyPrice = ?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?, conditions = ?, sysdate = ?, userid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantrawdestruction->storeid);
        $sqlQuery->setNumber($restaurantrawdestruction->productid);
        $sqlQuery->setNumber($restaurantrawdestruction->quantity);
        $sqlQuery->setNumber($restaurantrawdestruction->productBuyPrice);
        $sqlQuery->setNumber($restaurantrawdestruction->lastbuyprice);
        $sqlQuery->setNumber($restaurantrawdestruction->meanbuyprice);
        $sqlQuery->setNumber((float) $restaurantrawdestruction->lastbuyprice_withDiscount);
        $sqlQuery->setNumber((float) $restaurantrawdestruction->meanbuyprice_withDiscount);
        $sqlQuery->setNumber($restaurantrawdestruction->conditions);
        $sqlQuery->set($restaurantrawdestruction->sysdate);
        $sqlQuery->setNumber($restaurantrawdestruction->userid);

        $sqlQuery->setNumber($restaurantrawdestruction->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantrawdestruction';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM restaurantrawdestruction WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM restaurantrawdestruction WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantrawdestructionMySql
     */
    protected function readRow($row) {
        $restaurantrawdestruction = new Restaurantrawdestruction();

        $restaurantrawdestruction->id = isset($row['id']) ? $row['id'] : '';
        $restaurantrawdestruction->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $restaurantrawdestruction->productid = isset($row['productid']) ? $row['productid'] : '';
        $restaurantrawdestruction->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $restaurantrawdestruction->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $restaurantrawdestruction->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $restaurantrawdestruction->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $restaurantrawdestruction->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $restaurantrawdestruction->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $restaurantrawdestruction->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $restaurantrawdestruction->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $restaurantrawdestruction->userid = isset($row['userid']) ? $row['userid'] : '';

        return $restaurantrawdestruction;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantrawdestructionMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>