<?php

/**
 * Class that operate on table 'restaurantorderdetails'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:37
 */
class RestaurantorderdetailsMySqlDAO implements RestaurantorderdetailsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantorderdetailsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantorderdetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantorderdetails ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantorderdetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantorderdetailsMySql restaurantorderdetail
     */
    public function insert($restaurantorderdetail) {
        $sql = 'INSERT INTO restaurantorderdetails (orderId, productId, quantity, price, total,notes,notesPrinted, isPrinted,printedQuantity) VALUES (?, ?, ?, ?, ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantorderdetail->orderId);
        $sqlQuery->setNumber($restaurantorderdetail->productId);
        $sqlQuery->setNumber($restaurantorderdetail->quantity);
        $sqlQuery->set($restaurantorderdetail->price);
        $sqlQuery->set($restaurantorderdetail->total);
        $sqlQuery->set($restaurantorderdetail->notes);
        $sqlQuery->set($restaurantorderdetail->notesPrinted);
        $sqlQuery->setNumber($restaurantorderdetail->isPrinted);
        $sqlQuery->setNumber($restaurantorderdetail->printedQuantity);

        $id = $this->executeInsert($sqlQuery);
        $restaurantorderdetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantorderdetailsMySql restaurantorderdetail
     */
    public function update($restaurantorderdetail) {
        $sql = 'UPDATE restaurantorderdetails SET orderId = ?, productId = ?, quantity = ?, price = ?, total = ?,notes = ?,notesPrinted = ?, isPrinted = ?,printedQuantity=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantorderdetail->orderId);
        $sqlQuery->setNumber($restaurantorderdetail->productId);
        $sqlQuery->setNumber($restaurantorderdetail->quantity);
        $sqlQuery->set($restaurantorderdetail->price);
        $sqlQuery->set($restaurantorderdetail->total);
        $sqlQuery->set($restaurantorderdetail->notes);
        $sqlQuery->set($restaurantorderdetail->notesPrinted);
        $sqlQuery->setNumber($restaurantorderdetail->isPrinted);
        $sqlQuery->setNumber($restaurantorderdetail->printedQuantity);

        $sqlQuery->setNumber($restaurantorderdetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantorderdetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderId($value) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrice($value) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotal($value) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE total = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsPrinted($value) {
        $sql = 'SELECT * FROM restaurantorderdetails WHERE isPrinted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrderId($value) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrice($value) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotal($value) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE total = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsPrinted($value) {
        $sql = 'DELETE FROM restaurantorderdetails WHERE isPrinted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantorderdetailsMySql
     */
    protected function readRow($row) {
        $restaurantorderdetail = new Restaurantorderdetail();

        $restaurantorderdetail->id = isset($row['id']) ? $row['id'] : '';
        $restaurantorderdetail->orderId = isset($row['orderId']) ? $row['orderId'] : '';
        $restaurantorderdetail->productId = isset($row['productId']) ? $row['productId'] : '';
        $restaurantorderdetail->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $restaurantorderdetail->price = isset($row['price']) ? $row['price'] : '';
        $restaurantorderdetail->total = isset($row['total']) ? $row['total'] : '';
        $restaurantorderdetail->notes = isset($row['notes']) ? $row['notes'] : '';
        $restaurantorderdetail->notesPrinted = isset($row['notesPrinted']) ? $row['notesPrinted'] : '';
        $restaurantorderdetail->isPrinted = isset($row['isPrinted']) ? $row['isPrinted'] : '';
        $restaurantorderdetail->printedQuantity = isset($row['printedQuantity']) ? $row['printedQuantity'] : '';
        //
        $restaurantorderdetail->productName = isset($row['productName']) ? $row['productName'] : '';

        return $restaurantorderdetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantorderdetailsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>