<?php

/**
 * Class that operate on table 'restaurantorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:37
 */
class RestaurantorderMySqlDAO implements RestaurantorderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantorderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantorder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantorder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantorder primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantorder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantorderMySql restaurantorder
     */
    public function insert($restaurantorder) {
        $sql = 'INSERT INTO restaurantorder (hallUserId, tableId,totalBill,discount,tax,netBill, finished,sellBillId,daySreial, userId, sysdate, del,billComment,payed,rest) VALUES (?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantorder->hallUserId);
        $sqlQuery->setNumber($restaurantorder->tableId);
        $sqlQuery->setNumber($restaurantorder->totalBill);
        $sqlQuery->setNumber($restaurantorder->discount);
        $sqlQuery->setNumber($restaurantorder->tax);
        $sqlQuery->setNumber($restaurantorder->netBill);
        $sqlQuery->setNumber($restaurantorder->finished);
        $sqlQuery->setNumber($restaurantorder->sellBillId);
        $sqlQuery->setNumber($restaurantorder->daySreial);
        $sqlQuery->setNumber($restaurantorder->userId);
        $sqlQuery->set($restaurantorder->sysdate);
        $sqlQuery->setNumber($restaurantorder->del);
        $sqlQuery->set($restaurantorder->billComment);
        $sqlQuery->setNumber((float)$restaurantorder->payed);
        $sqlQuery->setNumber((float)$restaurantorder->rest);

        $id = $this->executeInsert($sqlQuery);
        $restaurantorder->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantorderMySql restaurantorder
     */
    public function update($restaurantorder) {
        $sql = 'UPDATE restaurantorder SET hallUserId = ?, tableId = ?,totalBill=?,discount=?,tax = ?,netBill=?, finished = ?,sellBillId = ?,daySreial = ?, userId = ?, sysdate = ?, del = ?,billComment = ?,payed = ?,rest = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantorder->hallUserId);
        $sqlQuery->setNumber($restaurantorder->tableId);
        $sqlQuery->setNumber($restaurantorder->totalBill);
        $sqlQuery->setNumber($restaurantorder->discount);
        $sqlQuery->setNumber($restaurantorder->tax);
        $sqlQuery->setNumber($restaurantorder->netBill);
        $sqlQuery->setNumber($restaurantorder->finished);
        $sqlQuery->setNumber($restaurantorder->sellBillId);
        $sqlQuery->setNumber($restaurantorder->daySreial);
        $sqlQuery->setNumber($restaurantorder->userId);
        $sqlQuery->set($restaurantorder->sysdate);
        $sqlQuery->setNumber($restaurantorder->del);
        $sqlQuery->set($restaurantorder->billComment);
        $sqlQuery->setNumber((float)$restaurantorder->payed);
        $sqlQuery->setNumber((float)$restaurantorder->rest);

        $sqlQuery->setNumber($restaurantorder->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByHallUserId($value) {
        $sql = 'SELECT * FROM restaurantorder WHERE hallUserId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTableId($value) {
        $sql = 'SELECT * FROM restaurantorder WHERE tableId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinished($value) {
        $sql = 'SELECT * FROM restaurantorder WHERE finished = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM restaurantorder WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM restaurantorder WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM restaurantorder WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByHallUserId($value) {
        $sql = 'DELETE FROM restaurantorder WHERE hallUserId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTableId($value) {
        $sql = 'DELETE FROM restaurantorder WHERE tableId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinished($value) {
        $sql = 'DELETE FROM restaurantorder WHERE finished = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM restaurantorder WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM restaurantorder WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM restaurantorder WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantorderMySql
     */
    protected function readRow($row) {
        $restaurantorder = new Restaurantorder();

        $restaurantorder->id = isset($row['id']) ? $row['id'] : '';
        $restaurantorder->hallUserId = isset($row['hallUserId']) ? $row['hallUserId'] : '';
        $restaurantorder->tableId = isset($row['tableId']) ? $row['tableId'] : '';
        $restaurantorder->totalBill = isset($row['totalBill']) ? $row['totalBill'] : '';
        $restaurantorder->discount = isset($row['discount']) ? $row['discount'] : '';
        $restaurantorder->tax = isset($row['tax']) ? $row['tax'] : '';
        $restaurantorder->netBill = isset($row['netBill']) ? $row['netBill'] : '';
        $restaurantorder->finished = isset($row['finished']) ? $row['finished'] : '';
        $restaurantorder->sellBillId = isset($row['sellBillId']) ? $row['sellBillId'] : '';
        $restaurantorder->daySreial = isset($row['daySreial']) ? $row['daySreial'] : '';
        $restaurantorder->userId = isset($row['userId']) ? $row['userId'] : '';
        $restaurantorder->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $restaurantorder->del = isset($row['del']) ? $row['del'] : '';
        $restaurantorder->billComment = isset($row['billComment']) ? $row['billComment'] : '';
	$restaurantorder->payed = isset($row['payed']) ? $row['payed'] : '';
	$restaurantorder->restaurantplaystationplayid = isset($row['restaurantplaystationplayid']) ? $row['restaurantplaystationplayid'] : '';

        //
        $restaurantorder->productId = isset($row['productId']) ? $row['productId'] : '';
        $restaurantorder->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $restaurantorder->price = isset($row['price']) ? $row['price'] : '';
        $restaurantorder->total = isset($row['total']) ? $row['total'] : '';
        $restaurantorder->productName = isset($row['productName']) ? $row['productName'] : '';
        $restaurantorder->tableName = isset($row['tableName']) ? $row['tableName'] : '';
        $restaurantorder->hallName = isset($row['hallName']) ? $row['hallName'] : '';
        $restaurantorder->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $restaurantorder->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $restaurantorder->driverReciveDate = isset($row['driverReciveDate']) ? $row['driverReciveDate'] : '';
        $restaurantorder->deliveryStatus = isset($row['deliveryStatus']) ? $row['deliveryStatus'] : '';
        $restaurantorder->clientaddress = isset($row['clientaddress']) ? $row['clientaddress'] : '';
        $restaurantorder->clientdetails = isset($row['clientdetails']) ? $row['clientdetails'] : '';
        $restaurantorder->showAddress = isset($row['showAddress']) ? $row['showAddress'] : '';
        $restaurantorder->showDetails = isset($row['showDetails']) ? $row['showDetails'] : '';
        $restaurantorder->clientmobile = isset($row['clientmobile']) ? $row['clientmobile'] : '';
        $restaurantorder->clientphone = isset($row['clientphone']) ? $row['clientphone'] : '';
        $restaurantorder->showPhone = isset($row['showPhone']) ? $row['showPhone'] : '';
        $restaurantorder->showMobile = isset($row['showMobile']) ? $row['showMobile'] : '';
        $restaurantorder->rest = isset($row['rest']) ? $row['rest'] : '';

        return $restaurantorder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantorderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>