<?php

/**
 * Class that operate on table 'rentstore'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:05
 */
class RentstoreMySqlDAO implements RentstoreDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RentstoreMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rentstore WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rentstore';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rentstore ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rentstore primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM rentstore WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RentstoreMySql rentstore
     */
    public function insert($rentstore) {
        $sql = 'INSERT INTO rentstore (rentproductid, amount, rented) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($rentstore->rentproductid);
        $sqlQuery->setNumber($rentstore->amount);
        $sqlQuery->setNumber($rentstore->rented);

        $id = $this->executeInsert($sqlQuery);
        $rentstore->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RentstoreMySql rentstore
     */
    public function update($rentstore) {
        $sql = 'UPDATE rentstore SET rentproductid = ?, amount = ?, rented = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($rentstore->rentproductid);
        $sqlQuery->setNumber($rentstore->amount);
        $sqlQuery->setNumber($rentstore->rented);

        $sqlQuery->setNumber($rentstore->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rentstore';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRentproductid($value) {
        $sql = 'SELECT * FROM rentstore WHERE rentproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAmount($value) {
        $sql = 'SELECT * FROM rentstore WHERE amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRented($value) {
        $sql = 'SELECT * FROM rentstore WHERE rented = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRentproductid($value) {
        $sql = 'DELETE FROM rentstore WHERE rentproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAmount($value) {
        $sql = 'DELETE FROM rentstore WHERE amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRented($value) {
        $sql = 'DELETE FROM rentstore WHERE rented = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RentstoreMySql
     */
    protected function readRow($row) {
        $rentstore = new Rentstore();

        $rentstore->id = isset($row['id']) ? $row['id'] : '';
        $rentstore->rentproductid = isset($row['rentproductid']) ? $row['rentproductid'] : '';
        $rentstore->amount = isset($row['amount']) ? $row['amount'] : '';
        $rentstore->rented = isset($row['rented']) ? $row['rented'] : '';

        return $rentstore;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RentstoreMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>