<?php

/**
 * Class that operate on table 'rentbillprop'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:05
 */
class RentbillpropMySqlDAO implements RentbillpropDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RentbillpropMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rentbillprop WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rentbillprop';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rentbillprop ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rentbillprop primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM rentbillprop WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RentbillpropMySql rentbillprop
     */
    public function insert($rentbillprop) {
        $sql = 'INSERT INTO rentbillprop (billid, productid, type, supplierid, amount, rentprice, supplierprice, totalprice, suppliertotalpice, startdate, enddate, rentdays, status, delayvalue, delaytype, delypay, delayreset ,dailyentryid , diffdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($rentbillprop->billid);
        $sqlQuery->setNumber($rentbillprop->productid);
        $sqlQuery->set($rentbillprop->type);
        $sqlQuery->setNumber($rentbillprop->supplierid);
        $sqlQuery->setNumber($rentbillprop->amount);
        $sqlQuery->set($rentbillprop->rentprice);
        $sqlQuery->set($rentbillprop->supplierprice);
        $sqlQuery->set($rentbillprop->totalprice);
        $sqlQuery->set($rentbillprop->suppliertotalpice);
        $sqlQuery->set($rentbillprop->startdate);
        $sqlQuery->set($rentbillprop->enddate);
        $sqlQuery->setNumber($rentbillprop->rentdays);
        $sqlQuery->set($rentbillprop->status);
        $sqlQuery->set($rentbillprop->delayvalue);
        $sqlQuery->set($rentbillprop->delaytype);
        $sqlQuery->set($rentbillprop->delypay);
        $sqlQuery->set($rentbillprop->delayreset);
        $sqlQuery->setNumber($rentbillprop->dailyentryid);
        $sqlQuery->set($rentbillprop->diffdate);


        $id = $this->executeInsert($sqlQuery);
        $rentbillprop->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RentbillpropMySql rentbillprop
     */
    public function update($rentbillprop) {
        $sql = 'UPDATE rentbillprop SET billid = ?, productid = ?, type = ?, supplierid = ?, amount = ?, rentprice = ?, supplierprice = ?, totalprice = ?, suppliertotalpice = ?, startdate = ?, enddate = ?, rentdays = ?, status = ?, delayvalue = ?, delaytype = ?, delypay = ?, delayreset = ? , dailyentryid = ? , diffdate = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($rentbillprop->billid);
        $sqlQuery->setNumber($rentbillprop->productid);
        $sqlQuery->set($rentbillprop->type);
        $sqlQuery->setNumber($rentbillprop->supplierid);
        $sqlQuery->setNumber($rentbillprop->amount);
        $sqlQuery->set($rentbillprop->rentprice);
        $sqlQuery->set($rentbillprop->supplierprice);
        $sqlQuery->set($rentbillprop->totalprice);
        $sqlQuery->set($rentbillprop->suppliertotalpice);
        $sqlQuery->set($rentbillprop->startdate);
        $sqlQuery->set($rentbillprop->enddate);
        $sqlQuery->setNumber($rentbillprop->rentdays);
        $sqlQuery->set($rentbillprop->status);
        $sqlQuery->set($rentbillprop->delayvalue);
        $sqlQuery->set($rentbillprop->delaytype);
        $sqlQuery->set($rentbillprop->delypay);
        $sqlQuery->set($rentbillprop->delayreset);
        $sqlQuery->setNumber($rentbillprop->dailyentryid);
        $sqlQuery->set($rentbillprop->diffdate);

        $sqlQuery->setNumber($rentbillprop->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rentbillprop';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierid($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAmount($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRentprice($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE rentprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierprice($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE supplierprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalprice($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySuppliertotalpice($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE suppliertotalpice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStartdate($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE startdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEnddate($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE enddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRentdays($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE rentdays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStatus($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelayvalue($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE delayvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelaytype($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE delaytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelypay($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE delypay = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelayreset($value) {
        $sql = 'SELECT * FROM rentbillprop WHERE delayreset = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM rentbillprop WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM rentbillprop WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM rentbillprop WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierid($value) {
        $sql = 'DELETE FROM rentbillprop WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAmount($value) {
        $sql = 'DELETE FROM rentbillprop WHERE amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRentprice($value) {
        $sql = 'DELETE FROM rentbillprop WHERE rentprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierprice($value) {
        $sql = 'DELETE FROM rentbillprop WHERE supplierprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalprice($value) {
        $sql = 'DELETE FROM rentbillprop WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySuppliertotalpice($value) {
        $sql = 'DELETE FROM rentbillprop WHERE suppliertotalpice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStartdate($value) {
        $sql = 'DELETE FROM rentbillprop WHERE startdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEnddate($value) {
        $sql = 'DELETE FROM rentbillprop WHERE enddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRentdays($value) {
        $sql = 'DELETE FROM rentbillprop WHERE rentdays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStatus($value) {
        $sql = 'DELETE FROM rentbillprop WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelayvalue($value) {
        $sql = 'DELETE FROM rentbillprop WHERE delayvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelaytype($value) {
        $sql = 'DELETE FROM rentbillprop WHERE delaytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelypay($value) {
        $sql = 'DELETE FROM rentbillprop WHERE delypay = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelayreset($value) {
        $sql = 'DELETE FROM rentbillprop WHERE delayreset = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RentbillpropMySql
     */
    protected function readRow($row) {
        $rentbillprop = new Rentbillprop();

        $rentbillprop->id = isset($row['id']) ? $row['id'] : '';
        $rentbillprop->billid = isset($row['billid']) ? $row['billid'] : '';
        $rentbillprop->productid = isset($row['productid']) ? $row['productid'] : '';
        $rentbillprop->type = isset($row['type']) ? $row['type'] : '';
        $rentbillprop->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $rentbillprop->amount = isset($row['amount']) ? $row['amount'] : '';
        $rentbillprop->rentprice = isset($row['rentprice']) ? $row['rentprice'] : '';
        $rentbillprop->supplierprice = isset($row['supplierprice']) ? $row['supplierprice'] : '';
        $rentbillprop->totalprice = isset($row['totalprice']) ? $row['totalprice'] : '';
        $rentbillprop->suppliertotalpice = isset($row['suppliertotalpice']) ? $row['suppliertotalpice'] : '';
        $rentbillprop->startdate = isset($row['startdate']) ? $row['startdate'] : '';
        $rentbillprop->enddate = isset($row['enddate']) ? $row['enddate'] : '';
        $rentbillprop->rentdays = isset($row['rentdays']) ? $row['rentdays'] : '';
        $rentbillprop->status = isset($row['status']) ? $row['status'] : '';
        $rentbillprop->delayvalue = isset($row['delayvalue']) ? $row['delayvalue'] : '';
        $rentbillprop->delaytype = isset($row['delaytype']) ? $row['delaytype'] : '';
        $rentbillprop->delypay = isset($row['delypay']) ? $row['delypay'] : '';
        $rentbillprop->delayreset = isset($row['delayreset']) ? $row['delayreset'] : '';
        $rentbillprop->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $rentbillprop->diffdate = isset($row['diffdate']) ? $row['diffdate'] : '';

        return $rentbillprop;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RentbillpropMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>