<?php

/**
 * Class that operate on table 'rawmaterials'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class RawmaterialsMySqlDAO implements RawmaterialsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RawmaterialsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rawmaterials WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rawmaterials';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rawmaterials ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rawmaterial primary key
     */
    public function delete($rawmaterialid) {
        $sql = 'DELETE FROM rawmaterials WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($rawmaterialid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RawmaterialsMySql rawmaterial
     */
    public function insert($rawmaterial) {
        $sql = 'INSERT INTO rawmaterials (rawmaterialname, rawmaterialsdescription, rawmaterialprice, measurementunitid, openingbalance, rawmaterialscategoryid, tempdelete, currentdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rawmaterial->rawmaterialname);
        $sqlQuery->set($rawmaterial->rawmaterialsdescription);
        $sqlQuery->set($rawmaterial->rawmaterialprice);
        $sqlQuery->setNumber($rawmaterial->measurementunitid);
        $sqlQuery->set($rawmaterial->openingbalance);
        $sqlQuery->setNumber($rawmaterial->rawmaterialscategoryid);
        $sqlQuery->setNumber($rawmaterial->tempdelete);
        $sqlQuery->set($rawmaterial->currentdate);

        $id = $this->executeInsert($sqlQuery);
        $rawmaterial->rawmaterialid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RawmaterialsMySql rawmaterial
     */
    public function update($rawmaterial) {
        $sql = 'UPDATE rawmaterials SET rawmaterialname = ?, rawmaterialsdescription = ?, rawmaterialprice = ?, measurementunitid = ?, openingbalance = ?, rawmaterialscategoryid = ?, tempdelete = ?, currentdate = ? WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rawmaterial->rawmaterialname);
        $sqlQuery->set($rawmaterial->rawmaterialsdescription);
        $sqlQuery->set($rawmaterial->rawmaterialprice);
        $sqlQuery->setNumber($rawmaterial->measurementunitid);
        $sqlQuery->set($rawmaterial->openingbalance);
        $sqlQuery->setNumber($rawmaterial->rawmaterialscategoryid);
        $sqlQuery->setNumber($rawmaterial->tempdelete);
        $sqlQuery->set($rawmaterial->currentdate);

        $sqlQuery->setNumber($rawmaterial->rawmaterialid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rawmaterials';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialname($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE rawmaterialname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialsdescription($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE rawmaterialsdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialprice($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE rawmaterialprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeasurementunitid($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE measurementunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOpeningbalance($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE openingbalance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialscategoryid($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE rawmaterialscategoryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM rawmaterials WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialname($value) {
        $sql = 'DELETE FROM rawmaterials WHERE rawmaterialname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialsdescription($value) {
        $sql = 'DELETE FROM rawmaterials WHERE rawmaterialsdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialprice($value) {
        $sql = 'DELETE FROM rawmaterials WHERE rawmaterialprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeasurementunitid($value) {
        $sql = 'DELETE FROM rawmaterials WHERE measurementunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOpeningbalance($value) {
        $sql = 'DELETE FROM rawmaterials WHERE openingbalance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialscategoryid($value) {
        $sql = 'DELETE FROM rawmaterials WHERE rawmaterialscategoryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM rawmaterials WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM rawmaterials WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RawmaterialsMySql
     */
    protected function readRow($row) {
        $rawmaterial = new Rawmaterial();

        $rawmaterial->rawmaterialid = isset($row['rawmaterialid']) ? $row['rawmaterialid'] : '';
        $rawmaterial->rawmaterialname = isset($row['rawmaterialname']) ? $row['rawmaterialname'] : '';
        $rawmaterial->rawmaterialsdescription = isset($row['rawmaterialsdescription']) ? $row['rawmaterialsdescription'] : '';
        $rawmaterial->rawmaterialprice = isset($row['rawmaterialprice']) ? $row['rawmaterialprice'] : '';
        $rawmaterial->measurementunitid = isset($row['measurementunitid']) ? $row['measurementunitid'] : '';
        $rawmaterial->openingbalance = isset($row['openingbalance']) ? $row['openingbalance'] : '';
        $rawmaterial->rawmaterialscategoryid = isset($row['rawmaterialscategoryid']) ? $row['rawmaterialscategoryid'] : '';
        $rawmaterial->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        $rawmaterial->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';

        return $rawmaterial;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RawmaterialsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>