<?php

/**
 * Class that operate on table 'quickprofitstore'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-01-21 13:45
 */
class QuickprofitstoreMySqlDAO implements QuickprofitstoreDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return QuickprofitstoreMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM quickprofitstore WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM quickprofitstore';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM quickprofitstore ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param quickprofitstore primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM quickprofitstore WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param QuickprofitstoreMySql quickprofitstore
     */
    public function insert($quickprofitstore) {
        $sql = 'INSERT INTO quickprofitstore (storeId, theDate, sellVal, sellCostBuyPrice, sellCostLastBuyPrice, sellCostMeanBuyPrice, sellCostLastBuyPricewithDiscount, sellCostMeanBuyPricewithDiscount, returnSellVal, returnSellCostBuyPrice, returnSellCostLastBuyPrice, returnSellCostMeanBuyPrice, returnSellCostLastBuyPricewithDiscount, returnSellCostMeanBuyPricewithDiscount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($quickprofitstore->storeId);
        $sqlQuery->set($quickprofitstore->theDate);
        $sqlQuery->set($quickprofitstore->sellVal);
        $sqlQuery->set($quickprofitstore->sellCostBuyPrice);
        $sqlQuery->set($quickprofitstore->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitstore->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitstore->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitstore->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitstore->returnSellVal);
        $sqlQuery->set($quickprofitstore->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitstore->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitstore->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitstore->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitstore->returnSellCostMeanBuyPricewithDiscount);

        $id = $this->executeInsert($sqlQuery);
        $quickprofitstore->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param QuickprofitstoreMySql quickprofitstore
     */
    public function update($quickprofitstore) {
        $sql = 'UPDATE quickprofitstore SET storeId = ?, theDate = ?, sellVal = ?, sellCostBuyPrice = ?, sellCostLastBuyPrice = ?, sellCostMeanBuyPrice = ?, sellCostLastBuyPricewithDiscount = ?, sellCostMeanBuyPricewithDiscount = ?, returnSellVal = ?, returnSellCostBuyPrice = ?, returnSellCostLastBuyPrice = ?, returnSellCostMeanBuyPrice = ?, returnSellCostLastBuyPricewithDiscount = ?, returnSellCostMeanBuyPricewithDiscount = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($quickprofitstore->storeId);
        $sqlQuery->set($quickprofitstore->theDate);
        $sqlQuery->set($quickprofitstore->sellVal);
        $sqlQuery->set($quickprofitstore->sellCostBuyPrice);
        $sqlQuery->set($quickprofitstore->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitstore->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitstore->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitstore->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitstore->returnSellVal);
        $sqlQuery->set($quickprofitstore->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitstore->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitstore->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitstore->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitstore->returnSellCostMeanBuyPricewithDiscount);

        $sqlQuery->setNumber($quickprofitstore->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM quickprofitstore';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreId($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheDate($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellVal($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellVal($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitstore WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreId($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheDate($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellVal($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellVal($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitstore WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return QuickprofitstoreMySql
     */
    protected function readRow($row) {
        $quickprofitstore = new Quickprofitstore();

        $quickprofitstore->id = $row['id'];
        $quickprofitstore->storeId = $row['storeId'];
        $quickprofitstore->theDate = $row['theDate'];
        $quickprofitstore->sellVal = $row['sellVal'];
        $quickprofitstore->sellCostBuyPrice = $row['sellCostBuyPrice'];
        $quickprofitstore->sellCostLastBuyPrice = $row['sellCostLastBuyPrice'];
        $quickprofitstore->sellCostMeanBuyPrice = $row['sellCostMeanBuyPrice'];
        $quickprofitstore->sellCostLastBuyPricewithDiscount = $row['sellCostLastBuyPricewithDiscount'];
        $quickprofitstore->sellCostMeanBuyPricewithDiscount = $row['sellCostMeanBuyPricewithDiscount'];
        $quickprofitstore->sellCostOverAllAveragePrice = $row['sellCostOverAllAveragePrice'];
        $quickprofitstore->returnSellVal = $row['returnSellVal'];
        $quickprofitstore->returnSellCostBuyPrice = $row['returnSellCostBuyPrice'];
        $quickprofitstore->returnSellCostLastBuyPrice = $row['returnSellCostLastBuyPrice'];
        $quickprofitstore->returnSellCostMeanBuyPrice = $row['returnSellCostMeanBuyPrice'];
        $quickprofitstore->returnSellCostLastBuyPricewithDiscount = $row['returnSellCostLastBuyPricewithDiscount'];
        $quickprofitstore->returnSellCostMeanBuyPricewithDiscount = $row['returnSellCostMeanBuyPricewithDiscount'];
        $quickprofitstore->returnSellCostOverAllAveragePrice = $row['returnSellCostOverAllAveragePrice'];
        //
        $quickprofitstore->storeName = $row['storeName'];
        return $quickprofitstore;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return QuickprofitstoreMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>