<?php

/**
 * Class that operate on table 'productionrate'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
class ProductionrateMySqlDAO implements ProductionrateDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionrateMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionrate WHERE productionRateId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionrate';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionrate ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionrate primary key
     */
    public function delete($productionRateId) {
        $sql = 'DELETE FROM productionrate WHERE productionRateId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productionRateId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionrateMySql productionrate
     */
    public function insert($productionrate) {
        $sql = 'INSERT INTO productionrate (name, finalName, userId, thedate, conditions) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($productionrate->name);
        $sqlQuery->set($productionrate->finalName);
        $sqlQuery->setNumber($productionrate->userId);
        $sqlQuery->set($productionrate->thedate);
        $sqlQuery->setNumber($productionrate->conditions);

        $id = $this->executeInsert($sqlQuery);
        $productionrate->productionRateId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionrateMySql productionrate
     */
    public function update($productionrate) {
        $sql = 'UPDATE productionrate SET name = ?, finalName = ?, userId = ?, thedate = ?, conditions = ? WHERE productionRateId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($productionrate->name);
        $sqlQuery->set($productionrate->finalName);
        $sqlQuery->setNumber($productionrate->userId);
        $sqlQuery->set($productionrate->thedate);
        $sqlQuery->setNumber($productionrate->conditions);

        $sqlQuery->setNumber($productionrate->productionRateId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionrate';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM productionrate WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM productionrate WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheDate($value) {
        $sql = 'SELECT * FROM productionrate WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM productionrate WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM productionrate WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM productionrate WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheDate($value) {
        $sql = 'DELETE FROM productionrate WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM productionrate WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionrateMySql
     */
    protected function readRow($row) {
        $productionrate = new Productionrate();

        $productionrate->productionRateId = isset($row['productionRateId']) ? $row['productionRateId'] : '';
        $productionrate->name = isset($row['name']) ? $row['name'] : '';
        $productionrate->finalName = isset($row['finalName']) ? $row['finalName'] : '';
        $productionrate->userId = isset($row['userId']) ? $row['userId'] : '';
        $productionrate->thedate = isset($row['thedate']) ? $row['thedate'] : '';
        $productionrate->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        return $productionrate;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionrateMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>