<?php

/**
 * Class that operate on table 'productionorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-07 17:42
 */
class ProductionorderMySqlDAO implements ProductionorderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionorderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionorder WHERE productionOrderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionorder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionorder primary key
     */
    public function delete($productionOrderid) {
        $sql = 'DELETE FROM productionorder WHERE productionOrderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productionOrderid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionorderMySql productionorder
     */
    public function insert($productionorder) {
        $sql = 'INSERT INTO productionorder (name, orderDate, branchId, startDate, endDate, productId, stageId, storeId, outQuantity, measureUnitId, conditions, userId, orderStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($productionorder->name);
        $sqlQuery->set($productionorder->orderDate);
        $sqlQuery->setNumber($productionorder->branchId);
        $sqlQuery->set($productionorder->startDate);
        $sqlQuery->set($productionorder->endDate);
        $sqlQuery->setNumber($productionorder->productId);
        $sqlQuery->setNumber($productionorder->stageId);
        $sqlQuery->setNumber($productionorder->storeId);
        $sqlQuery->setNumber($productionorder->outQuantity);
        $sqlQuery->setNumber($productionorder->measureUnitId);
        $sqlQuery->setNumber($productionorder->conditions);
        $sqlQuery->setNumber($productionorder->userId);
        $sqlQuery->setNumber($productionorder->orderStatus);

        $id = $this->executeInsert($sqlQuery);
        $productionorder->productionOrderid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionorderMySql productionorder
     */
    public function update($productionorder) {
        $sql = 'UPDATE productionorder SET name = ?, orderDate = ?, branchId = ?, startDate = ?, endDate = ?, productId = ?, stageId = ?, storeId = ?, outQuantity = ?, measureUnitId = ?, conditions = ?, userId = ?, orderStatus = ? WHERE productionOrderid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($productionorder->name);
        $sqlQuery->set($productionorder->orderDate);
        $sqlQuery->setNumber($productionorder->branchId);
        $sqlQuery->set($productionorder->startDate);
        $sqlQuery->set($productionorder->endDate);
        $sqlQuery->setNumber($productionorder->productId);
        $sqlQuery->setNumber($productionorder->stageId);
        $sqlQuery->setNumber($productionorder->storeId);
        $sqlQuery->setNumber($productionorder->outQuantity);
        $sqlQuery->setNumber($productionorder->measureUnitId);
        $sqlQuery->setNumber($productionorder->conditions);
        $sqlQuery->setNumber($productionorder->userId);
        $sqlQuery->setNumber($productionorder->orderStatus);

        $sqlQuery->setNumber($productionorder->productionOrderid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM productionorder WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderDate($value) {
        $sql = 'SELECT * FROM productionorder WHERE orderDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM productionorder WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStartDate($value) {
        $sql = 'SELECT * FROM productionorder WHERE startDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEndDate($value) {
        $sql = 'SELECT * FROM productionorder WHERE endDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM productionorder WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageId($value) {
        $sql = 'SELECT * FROM productionorder WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOutQuantity($value) {
        $sql = 'SELECT * FROM productionorder WHERE outQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeasureUnitId($value) {
        $sql = 'SELECT * FROM productionorder WHERE measureUnitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM productionorder WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM productionorder WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderStatus($value) {
        $sql = 'SELECT * FROM productionorder WHERE orderStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM productionorder WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderDate($value) {
        $sql = 'DELETE FROM productionorder WHERE orderDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM productionorder WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStartDate($value) {
        $sql = 'DELETE FROM productionorder WHERE startDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEndDate($value) {
        $sql = 'DELETE FROM productionorder WHERE endDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM productionorder WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageId($value) {
        $sql = 'DELETE FROM productionorder WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOutQuantity($value) {
        $sql = 'DELETE FROM productionorder WHERE outQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeasureUnitId($value) {
        $sql = 'DELETE FROM productionorder WHERE measureUnitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM productionorder WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM productionorder WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderStatus($value) {
        $sql = 'DELETE FROM productionorder WHERE orderStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionorderMySql
     */
    protected function readRow($row) {
        $productionorder = new Productionorder();

        $productionorder->productionOrderid = isset($row['productionOrderid']) ? $row['productionOrderid'] : '';
        $productionorder->name = isset($row['name']) ? $row['name'] : '';
        $productionorder->orderDate = isset($row['orderDate']) ? $row['orderDate'] : '';
        $productionorder->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $productionorder->startDate = isset($row['startDate']) ? $row['startDate'] : '';
        $productionorder->endDate = isset($row['endDate']) ? $row['endDate'] : '';
        $productionorder->productId = isset($row['productId']) ? $row['productId'] : '';
        $productionorder->stageId = isset($row['stageId']) ? $row['stageId'] : '';
        $productionorder->storeId = isset($row['storeId']) ? $row['storeId'] : '';
        $productionorder->outQuantity = isset($row['outQuantity']) ? $row['outQuantity'] : '';
        $productionorder->measureUnitId = isset($row['measureUnitId']) ? $row['measureUnitId'] : '';
        $productionorder->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $productionorder->userId = isset($row['userId']) ? $row['userId'] : '';
        $productionorder->orderStatus = isset($row['orderStatus']) ? $row['orderStatus'] : '';
        $productionorder->productName = isset($row['productName']) ? $row['productName'] : '';


        return $productionorder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionorderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>