<?php

/**
 * Class that operate on table 'productionexecutionwaste'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:58
 */
class ProductionexecutionwasteMySqlDAO implements ProductionexecutionwasteDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionexecutionwasteMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionexecutionwaste';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionexecutionwaste ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionexecutionwaste primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionexecutionwasteMySql productionexecutionwaste
     */
    public function insert($productionexecutionwaste) {
        $sql = 'INSERT INTO productionexecutionwaste (executionid, productid, allprice, halfprice, unitprice, num, storeid) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionexecutionwaste->executionid);
        $sqlQuery->setNumber($productionexecutionwaste->productid);
        $sqlQuery->set($productionexecutionwaste->allprice);
        $sqlQuery->set($productionexecutionwaste->halfprice);
        $sqlQuery->set($productionexecutionwaste->unitprice);
        $sqlQuery->setNumber($productionexecutionwaste->num);
        $sqlQuery->setNumber($productionexecutionwaste->storeid);

        $id = $this->executeInsert($sqlQuery);
        $productionexecutionwaste->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionexecutionwasteMySql productionexecutionwaste
     */
    public function update($productionexecutionwaste) {
        $sql = 'UPDATE productionexecutionwaste SET executionid = ?, productid = ?, allprice = ?, halfprice = ?, unitprice = ?, num = ?, storeid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionexecutionwaste->executionid);
        $sqlQuery->setNumber($productionexecutionwaste->productid);
        $sqlQuery->set($productionexecutionwaste->allprice);
        $sqlQuery->set($productionexecutionwaste->halfprice);
        $sqlQuery->set($productionexecutionwaste->unitprice);
        $sqlQuery->setNumber($productionexecutionwaste->num);
        $sqlQuery->setNumber($productionexecutionwaste->storeid);

        $sqlQuery->setNumber($productionexecutionwaste->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionexecutionwaste';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByExecutionid($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE executionid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAllprice($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE allprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHalfprice($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE halfprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitprice($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE unitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNum($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM productionexecutionwaste WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByExecutionid($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE executionid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAllprice($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE allprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHalfprice($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE halfprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitprice($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE unitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNum($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM productionexecutionwaste WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionexecutionwasteMySql
     */
    protected function readRow($row) {
        $productionexecutionwaste = new Productionexecutionwaste();

        $productionexecutionwaste->id = $row['id'];
        $productionexecutionwaste->executionid = $row['executionid'];
        $productionexecutionwaste->productid = $row['productid'];
        $productionexecutionwaste->allprice = $row['allprice'];
        $productionexecutionwaste->halfprice = $row['halfprice'];
        $productionexecutionwaste->unitprice = $row['unitprice'];
        $productionexecutionwaste->num = $row['num'];
        $productionexecutionwaste->storeid = $row['storeid'];

        $productionexecutionwaste->productName = $row['productName'];
        $productionexecutionwaste->unitName = $row['unitName'];
        $productionexecutionwaste->productBuyPrice = $row['productBuyPrice'];

        return $productionexecutionwaste;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionexecutionwasteMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>