<?php

/**
 * Class that operate on table 'productionexecutionoutput'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:58
 */
class ProductionexecutionoutputMySqlDAO implements ProductionexecutionoutputDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionexecutionoutputMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionexecutionoutput';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionexecutionoutput ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionexecutionoutput primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionexecutionoutputMySql productionexecutionoutput
     */
    public function insert($productionexecutionoutput) {
        $sql = 'INSERT INTO productionexecutionoutput (exeutionid, productid, allprice, halfprice, unitprice, num, cost, storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionexecutionoutput->exeutionid);
        $sqlQuery->setNumber($productionexecutionoutput->productid);
        $sqlQuery->set($productionexecutionoutput->allprice);
        $sqlQuery->set($productionexecutionoutput->halfprice);
        $sqlQuery->set($productionexecutionoutput->unitprice);
        $sqlQuery->setNumber($productionexecutionoutput->num);
        $sqlQuery->set($productionexecutionoutput->cost);
        $sqlQuery->setNumber($productionexecutionoutput->storeid);

        $id = $this->executeInsert($sqlQuery);
        $productionexecutionoutput->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionexecutionoutputMySql productionexecutionoutput
     */
    public function update($productionexecutionoutput) {
        $sql = 'UPDATE productionexecutionoutput SET exeutionid = ?, productid = ?, allprice = ?, halfprice = ?, unitprice = ?, num = ?, cost = ?, storeid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionexecutionoutput->exeutionid);
        $sqlQuery->setNumber($productionexecutionoutput->productid);
        $sqlQuery->set($productionexecutionoutput->allprice);
        $sqlQuery->set($productionexecutionoutput->halfprice);
        $sqlQuery->set($productionexecutionoutput->unitprice);
        $sqlQuery->setNumber($productionexecutionoutput->num);
        $sqlQuery->set($productionexecutionoutput->cost);
        $sqlQuery->setNumber($productionexecutionoutput->storeid);

        $sqlQuery->setNumber($productionexecutionoutput->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionexecutionoutput';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByExeutionid($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE exeutionid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAllprice($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE allprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHalfprice($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE halfprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitprice($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE unitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNum($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCost($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM productionexecutionoutput WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByExeutionid($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE exeutionid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAllprice($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE allprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHalfprice($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE halfprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitprice($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE unitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNum($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCost($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM productionexecutionoutput WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionexecutionoutputMySql
     */
    protected function readRow($row) {
        $productionexecutionoutput = new Productionexecutionoutput();

        $productionexecutionoutput->id = $row['id'];
        $productionexecutionoutput->exeutionid = $row['exeutionid'];
        $productionexecutionoutput->productid = $row['productid'];
        $productionexecutionoutput->allprice = $row['allprice'];
        $productionexecutionoutput->halfprice = $row['halfprice'];
        $productionexecutionoutput->unitprice = $row['unitprice'];
        $productionexecutionoutput->num = $row['num'];
        $productionexecutionoutput->cost = $row['cost'];
        $productionexecutionoutput->storeid = $row['storeid'];

        $productionexecutionoutput->productName = $row['productName'];
        $productionexecutionoutput->unitName = $row['unitName'];
        $productionexecutionoutput->productBuyPrice = $row['productBuyPrice'];

        $productionexecutionoutput->orderId = $row['orderId'];
        $productionexecutionoutput->orderdate = $row['orderdate'];
        $productionexecutionoutput->rentcost = $row['rentcost'];
        $productionexecutionoutput->othercost = $row['othercost'];

        return $productionexecutionoutput;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionexecutionoutputMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>