<?php

/**
 * Class that operate on table 'productcat'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProductcatMySqlDAO implements ProductcatDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductcatMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productcat WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productcat';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productcat ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productcat primary key
     */
    public function delete($productCatId) {
        $sql = 'DELETE FROM productcat WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productCatId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductcatMySql productcat
     */
    public function insert($productcat) {
        $sql = 'INSERT INTO productcat (productCatName, productCatDate, productCatDescription, productCatParent, userId, conditions, selldiscount, buydiscount, discounttype,isOptic , buytotal , buyhalf , buypart ,buypricereal,opticServices,logo,inMenu,stopNegativeSale,catExcelid,webApiId) VALUES (?,?,?,?, ?,?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($productcat->productCatName);
        $sqlQuery->set($productcat->productCatDate);
        $sqlQuery->setString2($productcat->productCatDescription);
        $sqlQuery->setNumber($productcat->productCatParent);
        $sqlQuery->setNumber($productcat->userId);
        $sqlQuery->setNumber($productcat->conditions);
        $sqlQuery->setNumber($productcat->selldiscount);
        $sqlQuery->setNumber($productcat->buydiscount);
        $sqlQuery->setNumber($productcat->discounttype);
        $sqlQuery->setNumber($productcat->isOptic);
        $sqlQuery->setNumber($productcat->buytotal);
        $sqlQuery->setNumber($productcat->buyhalf);
        $sqlQuery->setNumber($productcat->buypart);
        $sqlQuery->setNumber($productcat->buypricereal);
        $sqlQuery->set($productcat->opticServices);
        $sqlQuery->set($productcat->logo);
        $sqlQuery->setNumber($productcat->inMenu);
        $sqlQuery->setNumber((int) $productcat->stopNegativeSale);
        $sqlQuery->setNumber((int) $productcat->catExcelid);
        $sqlQuery->setNumber((int) $productcat->webApiId);

        $id = $this->executeInsert($sqlQuery);
        $productcat->productCatId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductcatMySql productcat
     */
    public function update($productcat) {
        $sql = 'UPDATE productcat SET productCatName = ?, productCatDate = ?, productCatDescription = ?, productCatParent = ?, userId = ?, conditions = ?, selldiscount = ?, buydiscount = ?, discounttype = ?,isOptic = ? , buytotal = ? , buyhalf = ? , buypart = ? , buypricereal = ?, opticServices = ?,logo = ?,inMenu=?,stopNegativeSale=? WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($productcat->productCatName);
        $sqlQuery->set($productcat->productCatDate);
        $sqlQuery->setString2($productcat->productCatDescription);
        $sqlQuery->setNumber($productcat->productCatParent);
        $sqlQuery->setNumber($productcat->userId);
        $sqlQuery->setNumber($productcat->conditions);
        $sqlQuery->setNumber($productcat->selldiscount);
        $sqlQuery->setNumber($productcat->buydiscount);
        $sqlQuery->setNumber($productcat->discounttype);
        $sqlQuery->setNumber($productcat->isOptic);
        $sqlQuery->setNumber($productcat->buytotal);
        $sqlQuery->setNumber($productcat->buyhalf);
        $sqlQuery->setNumber($productcat->buypart);
        $sqlQuery->setNumber($productcat->buypricereal);
        $sqlQuery->set($productcat->opticServices);
        $sqlQuery->set($productcat->logo);
        $sqlQuery->setNumber($productcat->inMenu);
        $sqlQuery->setNumber((int) $productcat->stopNegativeSale);

        $sqlQuery->setNumber($productcat->productCatId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productcat';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductCatName($value) {
        $sql = 'SELECT * FROM productcat WHERE productCatName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        //print_r($sqlQuery);
        return $this->getList($sqlQuery);
    }

    public function queryByProductCatDate($value) {
        $sql = 'SELECT * FROM productcat WHERE productCatDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductCatDescription($value) {
        $sql = 'SELECT * FROM productcat WHERE productCatDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductCatParent($value) {
        $sql = 'SELECT * FROM productcat WHERE productCatParent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM productcat WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM productcat WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductCatName($value) {
        $sql = 'DELETE FROM productcat WHERE productCatName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductCatDate($value) {
        $sql = 'DELETE FROM productcat WHERE productCatDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductCatDescription($value) {
        $sql = 'DELETE FROM productcat WHERE productCatDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductCatParent($value) {
        $sql = 'DELETE FROM productcat WHERE productCatParent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM productcat WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM productcat WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductcatMySql
     */
    protected function readRow($row) {
        $productcat = new Productcat();

        $productcat->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $productcat->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $productcat->productCatDate = isset($row['productCatDate']) ? $row['productCatDate'] : '';
        $productcat->productCatDescription = isset($row['productCatDescription']) ? $row['productCatDescription'] : '';
        $productcat->productCatParent = isset($row['productCatParent']) ? $row['productCatParent'] : '';
        $productcat->userId = isset($row['userId']) ? $row['userId'] : '';
        $productcat->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $productcat->selldiscount = isset($row['selldiscount']) ? $row['selldiscount'] : '';
        $productcat->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $productcat->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $productcat->isOptic = isset($row['isOptic']) ? $row['isOptic'] : '';
        $productcat->buytotal = isset($row['buytotal']) ? $row['buytotal'] : '';
        $productcat->buyhalf = isset($row['buyhalf']) ? $row['buyhalf'] : '';
        $productcat->buypart = isset($row['buypart']) ? $row['buypart'] : '';
        $productcat->buypricereal = isset($row['buypricereal']) ? $row['buypricereal'] : '';
        $productcat->opticServices = isset($row['opticServices']) ? $row['opticServices'] : '';
        $productcat->logo = isset($row['logo']) ? $row['logo'] : '';
        $productcat->inMenu = isset($row['inMenu']) ? $row['inMenu'] : '';
        $productcat->stopNegativeSale = isset($row['stopNegativeSale']) ? $row['stopNegativeSale'] : '';
        $productcat->catExcelid = isset($row['catExcelid']) ? $row['catExcelid'] : '';
        $productcat->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';


        //required
        $productcat->parentName = isset($row['parentName']) ? $row['parentName'] : '';
        $productcat->edited = isset($row['edited']) ? $row['edited'] : '';

        return $productcat;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductcatMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>