<?php
/**
 * Class that operate on table 'premium_installments'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-04-25 01:52
 */
class PremiumInstallmentsMySqlDAO implements PremiumInstallmentsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return PremiumInstallmentsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM premiuminstallments WHERE id_installment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM premiuminstallments';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM premiuminstallments ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param premiumInstallment primary key
 	 */
	public function delete($id_installment){
		$sql = 'DELETE FROM premiuminstallments WHERE id_installment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id_installment);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PremiumInstallmentsMySql premiumInstallment
 	 */
	public function insert($premiumInstallment){
		$sql = 'INSERT INTO premiuminstallments (date, value, premiumauo_id, payed, conditions) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($premiumInstallment->date);
		$sqlQuery->setNumber($premiumInstallment->value);
		$sqlQuery->setNumber($premiumInstallment->premiumauoId);
		$sqlQuery->setNumber($premiumInstallment->payed);
		$sqlQuery->setNumber($premiumInstallment->conditions);

		$id = $this->executeInsert($sqlQuery);	
		$premiumInstallment->idInstallment = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param PremiumInstallmentsMySql premiumInstallment
 	 */
	public function update($premiumInstallment){
		$sql = 'UPDATE premiuminstallments SET date = ?, value = ?, premiumauo_id = ?, payed = ?, conditions = ? WHERE id_installment = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($premiumInstallment->date);
		$sqlQuery->setNumber($premiumInstallment->value);
		$sqlQuery->setNumber($premiumInstallment->premiumauoId);
		$sqlQuery->setNumber($premiumInstallment->payed);
		$sqlQuery->setNumber($premiumInstallment->conditions);

		$sqlQuery->setNumber($premiumInstallment->idInstallment);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM premiuminstallments';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM premiuminstallments WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByValue($value){
		$sql = 'SELECT * FROM premiuminstallments WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPremiumauoId($value){
		$sql = 'SELECT * FROM premiuminstallments WHERE premiumauo_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPayed($value){
		$sql = 'SELECT * FROM premiuminstallments WHERE payed = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM premiuminstallments WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDate($value){
		$sql = 'DELETE FROM premiuminstallments WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByValue($value){
		$sql = 'DELETE FROM premiuminstallments WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPremiumauoId($value){
		$sql = 'DELETE FROM premiuminstallments WHERE premiumauo_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPayed($value){
		$sql = 'DELETE FROM premiuminstallments WHERE payed = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM premiuminstallments WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return PremiumInstallmentsMySql 
	 */
	protected function readRow($row){
		$premiumInstallment = new PremiumInstallment();
		
		$premiumInstallment->idInstallment = $row['id_installment'];
		$premiumInstallment->date = $row['date'];
		$premiumInstallment->value = $row['value'];
		$premiumInstallment->premiumauoId = $row['premiumauo_id'];
		$premiumInstallment->payed = $row['payed'];
		$premiumInstallment->conditions = $row['conditions'];
        $premiumInstallment->clientid = isset($row['clientid']) ? $row['clientid'] : '';


        return $premiumInstallment;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return PremiumInstallmentsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>