<?php

/**
 * Class that operate on table 'policy'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 10:51
 */
class PolicyMySqlDAO implements PolicyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PolicyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM policy WHERE policyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM policy';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM policy ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param policy primary key
     */
    public function delete($policyId) {
        $sql = 'DELETE FROM policy WHERE policyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($policyId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PolicyMySql policy
     */
    public function insert($policy) {
        $sql = 'INSERT INTO policy (policyName, policyDate, policyNum, policyCost, policyType, companyId, SenderName, tempdele, saveId,senderType,invoicenumber) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($policy->policyName);
        $sqlQuery->set($policy->policyDate);
        $sqlQuery->setNumber($policy->policyNum);
        $sqlQuery->set($policy->policyCost);
        $sqlQuery->setNumber($policy->policyType);
        $sqlQuery->setNumber($policy->companyId);
        $sqlQuery->set($policy->senderName);
        $sqlQuery->setNumber($policy->tempdele);
        $sqlQuery->setNumber($policy->saveId);
        $sqlQuery->setNumber($policy->senderType);
        $sqlQuery->set($policy->invoicenumber);


        $id = $this->executeInsert($sqlQuery);
        $policy->policyId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PolicyMySql policy
     */
    public function update($policy) {
        $sql = 'UPDATE policy SET policyName = ?, policyDate = ?, policyNum = ?, policyCost = ?, policyType = ?, companyId = ?, SenderName = ?, tempdele = ?, saveId = ?, senderType = ?, invoicenumber = ?  WHERE policyId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($policy->policyName);
        $sqlQuery->set($policy->policyDate);
        $sqlQuery->setNumber($policy->policyNum);
        $sqlQuery->set($policy->policyCost);
        $sqlQuery->setNumber($policy->policyType);
        $sqlQuery->setNumber($policy->companyId);
        $sqlQuery->set($policy->senderName);
        $sqlQuery->setNumber($policy->tempdele);
        $sqlQuery->setNumber($policy->saveId);
        $sqlQuery->setNumber($policy->senderType);
        $sqlQuery->set($policy->invoicenumber);

        $sqlQuery->setNumber($policy->policyId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM policy';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByPolicyName($value) {
        $sql = 'SELECT * FROM policy WHERE policyName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPolicyDate($value) {
        $sql = 'SELECT * FROM policy WHERE policyDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPolicyNum($value) {
        $sql = 'SELECT * FROM policy WHERE policyNum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPolicyCost($value) {
        $sql = 'SELECT * FROM policy WHERE policyCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPolicyType($value) {
        $sql = 'SELECT * FROM policy WHERE policyType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCompanyId($value) {
        $sql = 'SELECT * FROM policy WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySenderName($value) {
        $sql = 'SELECT * FROM policy WHERE SenderName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByPolicyName($value) {
        $sql = 'DELETE FROM policy WHERE policyName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPolicyDate($value) {
        $sql = 'DELETE FROM policy WHERE policyDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPolicyNum($value) {
        $sql = 'DELETE FROM policy WHERE policyNum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPolicyCost($value) {
        $sql = 'DELETE FROM policy WHERE policyCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPolicyType($value) {
        $sql = 'DELETE FROM policy WHERE policyType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCompanyId($value) {
        $sql = 'DELETE FROM policy WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySenderName($value) {
        $sql = 'DELETE FROM policy WHERE SenderName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PolicyMySql
     */
    protected function readRow($row) {
        $policy = new Policy();

        $policy->policyId = isset($row['policyId']) ? $row['policyId'] : '';
        $policy->policyName = isset($row['policyName']) ? $row['policyName'] : '';
        $policy->policyDate = isset($row['policyDate']) ? $row['policyDate'] : '';
        $policy->policyNum = isset($row['policyNum']) ? $row['policyNum'] : '';
        $policy->policyCost = isset($row['policyCost']) ? $row['policyCost'] : '';
        $policy->policyType = isset($row['policyType']) ? $row['policyType'] : '';
        $policy->companyId = isset($row['companyId']) ? $row['companyId'] : '';
        $policy->senderName = isset($row['SenderName']) ? $row['SenderName'] : '';
        $policy->tempdele = isset($row['tempdele']) ? $row['tempdele'] : '';
        $policy->saveId = isset($row['saveId']) ? $row['saveId'] : '';

        //required
        $policy->companyName = isset($row['companyName']) ? $row['companyName'] : '';

        $policy->senderType = isset($row['senderType']) ? $row['senderType'] : '';
        $policy->invoicenumber = isset($row['invoicenumber']) ? $row['invoicenumber'] : '';


        return $policy;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PolicyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>