<?php
/**
 * Class that operate on table 'playstationcard'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-06-24 11:15
 */
class PlaystationcardMySqlDAO implements PlaystationcardDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return PlaystationcardMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM playstationcard WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM playstationcard';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM playstationcard ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param playstationcard primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM playstationcard WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PlaystationcardMySql playstationcard
 	 */
	public function insert($playstationcard){
		$sql = 'INSERT INTO playstationcard (name, packageVal, packagePrice, packageDays, file, del, userid, sysdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($playstationcard->name);
		$sqlQuery->set($playstationcard->packageVal);
		$sqlQuery->set($playstationcard->packagePrice);
		$sqlQuery->setNumber($playstationcard->packageDays);
		$sqlQuery->set($playstationcard->file);
		$sqlQuery->setNumber($playstationcard->del);
		$sqlQuery->setNumber($playstationcard->userid);
		$sqlQuery->set($playstationcard->sysdate);

		$id = $this->executeInsert($sqlQuery);	
		$playstationcard->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param PlaystationcardMySql playstationcard
 	 */
	public function update($playstationcard){
		$sql = 'UPDATE playstationcard SET name = ?, packageVal = ?, packagePrice = ?, packageDays = ?, file = ?, del = ?, userid = ?, sysdate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($playstationcard->name);
		$sqlQuery->set($playstationcard->packageVal);
		$sqlQuery->set($playstationcard->packagePrice);
		$sqlQuery->setNumber($playstationcard->packageDays);
		$sqlQuery->set($playstationcard->file);
		$sqlQuery->setNumber($playstationcard->del);
		$sqlQuery->setNumber($playstationcard->userid);
		$sqlQuery->set($playstationcard->sysdate);

		$sqlQuery->setNumber($playstationcard->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM playstationcard';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM playstationcard WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPackageVal($value){
		$sql = 'SELECT * FROM playstationcard WHERE packageVal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPackagePrice($value){
		$sql = 'SELECT * FROM playstationcard WHERE packagePrice = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPackageDays($value){
		$sql = 'SELECT * FROM playstationcard WHERE packageDays = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFile($value){
		$sql = 'SELECT * FROM playstationcard WHERE file = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM playstationcard WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM playstationcard WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM playstationcard WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM playstationcard WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPackageVal($value){
		$sql = 'DELETE FROM playstationcard WHERE packageVal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPackagePrice($value){
		$sql = 'DELETE FROM playstationcard WHERE packagePrice = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPackageDays($value){
		$sql = 'DELETE FROM playstationcard WHERE packageDays = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFile($value){
		$sql = 'DELETE FROM playstationcard WHERE file = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM playstationcard WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM playstationcard WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM playstationcard WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return PlaystationcardMySql 
	 */
	protected function readRow($row){
		$playstationcard = new Playstationcard();
		
		$playstationcard->id = $row['id'];
		$playstationcard->name = $row['name'];
		$playstationcard->packageVal = $row['packageVal'];
		$playstationcard->packagePrice = $row['packagePrice'];
		$playstationcard->packageDays = $row['packageDays'];
		$playstationcard->file = $row['file'];
		$playstationcard->del = $row['del'];
		$playstationcard->userid = $row['userid'];
		$playstationcard->sysdate = $row['sysdate'];

		return $playstationcard;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return PlaystationcardMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>