<?php

/**
 * Class that operate on table 'partnerwithdrawal'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class PartnerwithdrawalMySqlDAO implements PartnerwithdrawalDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PartnerwithdrawalMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE partnerwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM partnerwithdrawal';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM partnerwithdrawal ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param partnerwithdrawal primary key
     */
    public function delete($partnerwithdrawalid) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE partnerwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($partnerwithdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PartnerwithdrawalMySql partnerwithdrawal
     */
    public function insert($partnerwithdrawal) {
        $sql = 'INSERT INTO partnerwithdrawal (partnerid, partnerwithdrawalvalue, comment, partnerwithdrawaldate, userid, saveid,partenrwithdrawaltype , conditions,dailyentryid,bankid,bankaccountid,checknum,partnerbefore,partnerafter) VALUES (?, ?,?, ?, ?, ?, ?, ?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($partnerwithdrawal->partnerid);
        $sqlQuery->set($partnerwithdrawal->partnerwithdrawalvalue);
        $sqlQuery->set($partnerwithdrawal->comment);
        $sqlQuery->set($partnerwithdrawal->partnerwithdrawaldate);
        $sqlQuery->setNumber($partnerwithdrawal->userid);
        $sqlQuery->setNumber($partnerwithdrawal->saveid);
        $sqlQuery->setNumber($partnerwithdrawal->partenrwithdrawaltype);
        $sqlQuery->setNumber($partnerwithdrawal->conditions);
        $sqlQuery->setNumber($partnerwithdrawal->dailyentryid);
        $sqlQuery->setNumber((int) $partnerwithdrawal->bankid);
        $sqlQuery->setNumber((int) $partnerwithdrawal->bankaccountid);
        $sqlQuery->setNumber((int) $partnerwithdrawal->checknum);
        $sqlQuery->set($partnerwithdrawal->partnerbefore);
        $sqlQuery->set($partnerwithdrawal->partnerafter);

        $id = $this->executeInsert($sqlQuery);
        $partnerwithdrawal->partnerwithdrawalid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PartnerwithdrawalMySql partnerwithdrawal
     */
    public function update($partnerwithdrawal) {
        $sql = 'UPDATE partnerwithdrawal SET partnerid = ?, partnerwithdrawalvalue = ?, comment = ?, partnerwithdrawaldate = ?, partenrwithdrawaltype = ?, userid = ?, saveid = ?, conditions = ? , dailyentryid = ? ,bankid=?,bankaccountid=?, checknum=?, partnerbefore=?, partnerafter=? WHERE partnerwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($partnerwithdrawal->partnerid);
        $sqlQuery->set($partnerwithdrawal->partnerwithdrawalvalue);
        $sqlQuery->set($partnerwithdrawal->comment);
        $sqlQuery->set($partnerwithdrawal->partnerwithdrawaldate);
        $sqlQuery->setNumber($partnerwithdrawal->partenrwithdrawaltype);
        $sqlQuery->setNumber($partnerwithdrawal->userid);
        $sqlQuery->setNumber($partnerwithdrawal->saveid);
        $sqlQuery->setNumber($partnerwithdrawal->conditions);
        $sqlQuery->setNumber($partnerwithdrawal->dailyentryid);
        $sqlQuery->setNumber((int) $partnerwithdrawal->bankid);
        $sqlQuery->setNumber((int) $partnerwithdrawal->bankaccountid);
        $sqlQuery->setNumber((int) $partnerwithdrawal->checknum);
        $sqlQuery->set($partnerwithdrawal->partnerbefore);
        $sqlQuery->set($partnerwithdrawal->partnerafter);

        $sqlQuery->setNumber($partnerwithdrawal->partnerwithdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM partnerwithdrawal';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByPartnerid($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE partnerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartnerwithdrawalvalue($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE partnerwithdrawalvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartnerwithdrawaldate($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE partnerwithdrawaldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM partnerwithdrawal WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByPartnerid($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE partnerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartnerwithdrawalvalue($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE partnerwithdrawalvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartnerwithdrawaldate($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE partnerwithdrawaldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM partnerwithdrawal WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PartnerwithdrawalMySql
     */
    protected function readRow($row) {
        $partnerwithdrawal = new Partnerwithdrawal();

        $partnerwithdrawal->partnerwithdrawalid = isset($row['partnerwithdrawalid']) ? $row['partnerwithdrawalid'] : '';
        $partnerwithdrawal->partnerid = isset($row['partnerid']) ? $row['partnerid'] : '';
        $partnerwithdrawal->partnerwithdrawalvalue = isset($row['partnerwithdrawalvalue']) ? $row['partnerwithdrawalvalue'] : '';
        $partnerwithdrawal->comment = isset($row['comment']) ? $row['comment'] : '';
        $partnerwithdrawal->partnerwithdrawaldate = isset($row['partnerwithdrawaldate']) ? $row['partnerwithdrawaldate'] : '';
        $partnerwithdrawal->userid = isset($row['userid']) ? $row['userid'] : '';
        $partnerwithdrawal->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $partnerwithdrawal->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $partnerwithdrawal->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $partnerwithdrawal->bankaccountid = isset($row['bankaccountid']) ? $row['bankaccountid'] : '';
        $partnerwithdrawal->checknum = isset($row['checknum']) ? $row['checknum'] : '';
        $partnerwithdrawal->partnerbefore = isset($row['partnerbefore']) ? $row['partnerbefore'] : '';
        $partnerwithdrawal->partnerafter = isset($row['partnerafter']) ? $row['partnerafter'] : '';


        //required
        $partnerwithdrawal->partnername = isset($row['partnername']) ? $row['partnername'] : '';
        $partnerwithdrawal->savename = isset($row['savename']) ? $row['savename'] : '';
        $partnerwithdrawal->partenrwithdrawaltype = isset($row['partenrwithdrawaltype']) ? $row['partenrwithdrawaltype'] : '';

        $partnerwithdrawal->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $partnerwithdrawal->bankname = isset($row['bankname']) ? $row['bankname'] : '';
        $partnerwithdrawal->accountname = isset($row['accountname']) ? $row['accountname'] : '';



        return $partnerwithdrawal;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PartnerwithdrawalMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>