<?php
/**
 * Class that operate on table 'partnertransferbetween'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-09-05 00:27
 */
class PartnertransferbetweenMySqlDAO implements PartnertransferbetweenDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return PartnertransferbetweenMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM partnertransferbetween WHERE partnertransferbetweenid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM partnertransferbetween';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM partnertransferbetween ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param partnertransferbetween primary key
 	 */
	public function delete($partnertransferbetweenid){
		$sql = 'DELETE FROM partnertransferbetween WHERE partnertransferbetweenid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($partnertransferbetweenid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PartnertransferbetweenMySql partnertransferbetween
 	 */
	public function insert($partnertransferbetween){
		$sql = 'INSERT INTO partnertransferbetween (partneridfrom, partneridto, partnervalue, comment, partnerdate, userid, conditions, partnerfrombefore, partnerfromafter, partnertobefore, partnertoafter) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($partnertransferbetween->partneridfrom);
		$sqlQuery->setNumber($partnertransferbetween->partneridto);
		$sqlQuery->set($partnertransferbetween->partnervalue);
		$sqlQuery->setString2($partnertransferbetween->comment);
		$sqlQuery->set($partnertransferbetween->partnerdate);
		$sqlQuery->setNumber($partnertransferbetween->userid);
		$sqlQuery->setNumber($partnertransferbetween->conditions);
		$sqlQuery->set($partnertransferbetween->partnerfrombefore);
		$sqlQuery->set($partnertransferbetween->partnerfromafter);
		$sqlQuery->set($partnertransferbetween->partnertobefore);
		$sqlQuery->set($partnertransferbetween->partnertoafter);

		$id = $this->executeInsert($sqlQuery);	
		$partnertransferbetween->partnertransferbetweenid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param PartnertransferbetweenMySql partnertransferbetween
 	 */
	public function update($partnertransferbetween){
		$sql = 'UPDATE partnertransferbetween SET partneridfrom = ?, partneridto = ?, partnervalue = ?, comment = ?, partnerdate = ?, userid = ?, conditions = ?, partnerfrombefore = ?, partnerfromafter = ?, partnertobefore = ?, partnertoafter = ? WHERE partnertransferbetweenid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($partnertransferbetween->partneridfrom);
		$sqlQuery->setNumber($partnertransferbetween->partneridto);
		$sqlQuery->set($partnertransferbetween->partnervalue);
		$sqlQuery->setString2($partnertransferbetween->comment);
		$sqlQuery->set($partnertransferbetween->partnerdate);
		$sqlQuery->setNumber($partnertransferbetween->userid);
		$sqlQuery->setNumber($partnertransferbetween->conditions);
		$sqlQuery->set($partnertransferbetween->partnerfrombefore);
		$sqlQuery->set($partnertransferbetween->partnerfromafter);
		$sqlQuery->set($partnertransferbetween->partnertobefore);
		$sqlQuery->set($partnertransferbetween->partnertoafter);


		$sqlQuery->setNumber($partnertransferbetween->partnertransferbetweenid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM partnertransferbetween';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByPartneridfrom($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE partneridfrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPartneridto($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE partneridto = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPartnervalue($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE partnervalue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPartnerdate($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE partnerdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM partnertransferbetween WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByPartneridfrom($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE partneridfrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPartneridto($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE partneridto = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPartnervalue($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE partnervalue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPartnerdate($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE partnerdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM partnertransferbetween WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return PartnertransferbetweenMySql 
	 */
	protected function readRow($row){
		$partnertransferbetween = new Partnertransferbetween();
		
		$partnertransferbetween->partnertransferbetweenid = $row['partnertransferbetweenid'];
		$partnertransferbetween->partneridfrom = $row['partneridfrom'];
		$partnertransferbetween->partneridto = $row['partneridto'];
		$partnertransferbetween->partnervalue = $row['partnervalue'];
		$partnertransferbetween->comment = $row['comment'];
		$partnertransferbetween->partnerdate = $row['partnerdate'];
		$partnertransferbetween->userid = $row['userid'];
		$partnertransferbetween->conditions = $row['conditions'];
		$partnertransferbetween->partnerfrombefore = $row['partnerfrombefore'];
		$partnertransferbetween->partnerfromafter = $row['partnerfromafter'];
		$partnertransferbetween->partnertobefore = $row['partnertobefore'];
		$partnertransferbetween->partnertoafter = $row['partnertoafter'];
		$partnertransferbetween->partneridformname = isset($row['partneridformname']) ? $row['partneridformname'] : '';
        $partnertransferbetween->partneridtoname = isset($row['partneridtoname']) ? $row['partneridtoname'] : '';

		return $partnertransferbetween;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return PartnertransferbetweenMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>