<?php

/**
 * Class that operate on table 'partner'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class PartnerMySqlDAO implements PartnerDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PartnerMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM partner WHERE partnerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM partner';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM partner ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param partner primary key
     */
    public function delete($partnerid) {
        $sql = 'DELETE FROM partner WHERE partnerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($partnerid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PartnerMySql partner
     */
    public function insert($partner, $comment) {
        $sql = 'INSERT INTO partner (partnername, partnerdate, partnerpercentage, partnermoney, conditions, comment, userid ,dailyentryid) VALUES (?, ?, ?, ?, ?, "' . $comment . '", ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($partner->partnername);
        $sqlQuery->set($partner->partnerdate);
        $sqlQuery->set($partner->partnerpercentage);
        $sqlQuery->set($partner->partnermoney);
        $sqlQuery->setNumber($partner->conditions);
        //$sqlQuery->set($partner->comment);
        $sqlQuery->setNumber($partner->userid);
        $sqlQuery->setNumber($partner->dailyentryid);

        $id = $this->executeInsert($sqlQuery);
        $partner->partnerid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PartnerMySql partner
     */
    public function update($partner, $comment) {
        $sql = 'UPDATE partner SET partnername = ?, partnerdate = ?, partnerpercentage = ?, partnermoney = ?, conditions = ?, comment = "' . $comment . '", userid = ? ,dailyentryid=? WHERE partnerid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($partner->partnername);
        $sqlQuery->set($partner->partnerdate);
        $sqlQuery->set($partner->partnerpercentage);
        $sqlQuery->set($partner->partnermoney);
        $sqlQuery->setNumber($partner->conditions);
        //$sqlQuery->set($partner->comment);
        $sqlQuery->setNumber($partner->userid);
        $sqlQuery->setNumber($partner->dailyentryid);

        $sqlQuery->setNumber($partner->partnerid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM partner';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByPartnername($value) {
        $sql = 'SELECT * FROM partner WHERE partnername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartnerdate($value) {
        $sql = 'SELECT * FROM partner WHERE partnerdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartnerpercentage($value) {
        $sql = 'SELECT * FROM partner WHERE partnerpercentage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartnermoney($value) {
        $sql = 'SELECT * FROM partner WHERE partnermoney = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM partner WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM partner WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM partner WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByPartnername($value) {
        $sql = 'DELETE FROM partner WHERE partnername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartnerdate($value) {
        $sql = 'DELETE FROM partner WHERE partnerdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartnerpercentage($value) {
        $sql = 'DELETE FROM partner WHERE partnerpercentage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartnermoney($value) {
        $sql = 'DELETE FROM partner WHERE partnermoney = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM partner WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM partner WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM partner WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PartnerMySql
     */
    protected function readRow($row) {
        $partner = new Partner();

        $partner->partnerid = isset($row['partnerid']) ? $row['partnerid'] : '';
        $partner->partnername = isset($row['partnername']) ? $row['partnername'] : '';
        $partner->partnerdate = isset($row['partnerdate']) ? $row['partnerdate'] : '';
        $partner->partnerpercentage = isset($row['partnerpercentage']) ? $row['partnerpercentage'] : '';
        $partner->partnermoney = isset($row['partnermoney']) ? $row['partnermoney'] : '';
        $partner->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $partner->comment = isset($row['comment']) ? $row['comment'] : '';
        $partner->userid = isset($row['userid']) ? $row['userid'] : '';
        $partner->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';

        return $partner;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PartnerMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>