<?php
/**
 * Class that operate on table 'offerproorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-09-24 12:55
 */
class OfferproorderMySqlDAO implements OfferproorderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OfferproorderMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM offerproorder WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM offerproorder';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM offerproorder ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param offerproorder primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM offerproorder WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OfferproorderMySql offerproorder
 	 */
	public function insert($offerproorder){
		$sql = 'INSERT INTO offerproorder (clientid, productid, quantity, storequant, availablequant, miunquant, price, total) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($offerproorder->clientid);
		$sqlQuery->setNumber($offerproorder->productid);
		$sqlQuery->setNumber($offerproorder->quantity);
		$sqlQuery->setNumber($offerproorder->storequant);
		$sqlQuery->setNumber($offerproorder->availablequant);
		$sqlQuery->setNumber($offerproorder->miunquant);
		$sqlQuery->setNumber($offerproorder->price);
		$sqlQuery->setNumber($offerproorder->total);

		$id = $this->executeInsert($sqlQuery);	
		$offerproorder->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OfferproorderMySql offerproorder
 	 */
	public function update($offerproorder){
		$sql = 'UPDATE offerproorder SET clientid = ?, productid = ?, quantity = ?, storequant = ?, availablequant = ?, miunquant = ?, price = ?, total = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($offerproorder->clientid);
		$sqlQuery->setNumber($offerproorder->productid);
		$sqlQuery->setNumber($offerproorder->quantity);
		$sqlQuery->setNumber($offerproorder->storequant);
		$sqlQuery->setNumber($offerproorder->availablequant);
		$sqlQuery->setNumber($offerproorder->miunquant);
		$sqlQuery->setNumber($offerproorder->price);
		$sqlQuery->setNumber($offerproorder->total);

		$sqlQuery->setNumber($offerproorder->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM offerproorder';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM offerproorder WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM offerproorder WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByQuantity($value){
		$sql = 'SELECT * FROM offerproorder WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStorequant($value){
		$sql = 'SELECT * FROM offerproorder WHERE storequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAvailablequant($value){
		$sql = 'SELECT * FROM offerproorder WHERE availablequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMiunquant($value){
		$sql = 'SELECT * FROM offerproorder WHERE miunquant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPrice($value){
		$sql = 'SELECT * FROM offerproorder WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotal($value){
		$sql = 'SELECT * FROM offerproorder WHERE total = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientid($value){
		$sql = 'DELETE FROM offerproorder WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductid($value){
		$sql = 'DELETE FROM offerproorder WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByQuantity($value){
		$sql = 'DELETE FROM offerproorder WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStorequant($value){
		$sql = 'DELETE FROM offerproorder WHERE storequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAvailablequant($value){
		$sql = 'DELETE FROM offerproorder WHERE availablequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMiunquant($value){
		$sql = 'DELETE FROM offerproorder WHERE miunquant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPrice($value){
		$sql = 'DELETE FROM offerproorder WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotal($value){
		$sql = 'DELETE FROM offerproorder WHERE total = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OfferproorderMySql 
	 */
	protected function readRow($row){
		$offerproorder = new Offerproorder();
		
		$offerproorder->id = $row['id'];
		$offerproorder->clientid = $row['clientid'];
		$offerproorder->productid = $row['productid'];
		$offerproorder->quantity = $row['quantity'];
		$offerproorder->storequant = $row['storequant'];
		$offerproorder->availablequant = $row['availablequant'];
		$offerproorder->miunquant = $row['miunquant'];
		$offerproorder->price = $row['price'];
		$offerproorder->total = $row['total'];

		return $offerproorder;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OfferproorderMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>