<?php
/**
 * Class that operate on table 'offerproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-09-24 12:55
 */
class OfferproductMySqlDAO implements OfferproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OfferproductMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM offerproduct WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM offerproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM offerproduct ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param offerproduct primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM offerproduct WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OfferproductMySql offerproduct
 	 */
	public function insert($offerproduct){
		$sql = 'INSERT INTO offerproduct (clientid, productid, quantity, storequant, availablequant, miunquant, price, total) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($offerproduct->clientid);
		$sqlQuery->setNumber($offerproduct->productid);
		$sqlQuery->setNumber($offerproduct->quantity);
		$sqlQuery->setNumber($offerproduct->storequant);
		$sqlQuery->setNumber($offerproduct->availablequant);
		$sqlQuery->setNumber($offerproduct->miunquant);
		$sqlQuery->setNumber($offerproduct->price);
		$sqlQuery->setNumber($offerproduct->total);

		$id = $this->executeInsert($sqlQuery);	
		$offerproduct->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OfferproductMySql offerproduct
 	 */
	public function update($offerproduct){
		$sql = 'UPDATE offerproduct SET clientid = ?, productid = ?, quantity = ?, storequant = ?, availablequant = ?, miunquant = ?, price = ?, total = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($offerproduct->clientid);
		$sqlQuery->setNumber($offerproduct->productid);
		$sqlQuery->setNumber($offerproduct->quantity);
		$sqlQuery->setNumber($offerproduct->storequant);
		$sqlQuery->setNumber($offerproduct->availablequant);
		$sqlQuery->setNumber($offerproduct->miunquant);
		$sqlQuery->setNumber($offerproduct->price);
		$sqlQuery->setNumber($offerproduct->total);

		$sqlQuery->setNumber($offerproduct->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM offerproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM offerproduct WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM offerproduct WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByQuantity($value){
		$sql = 'SELECT * FROM offerproduct WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStorequant($value){
		$sql = 'SELECT * FROM offerproduct WHERE storequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAvailablequant($value){
		$sql = 'SELECT * FROM offerproduct WHERE availablequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMiunquant($value){
		$sql = 'SELECT * FROM offerproduct WHERE miunquant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPrice($value){
		$sql = 'SELECT * FROM offerproduct WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotal($value){
		$sql = 'SELECT * FROM offerproduct WHERE total = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientid($value){
		$sql = 'DELETE FROM offerproduct WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductid($value){
		$sql = 'DELETE FROM offerproduct WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByQuantity($value){
		$sql = 'DELETE FROM offerproduct WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStorequant($value){
		$sql = 'DELETE FROM offerproduct WHERE storequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAvailablequant($value){
		$sql = 'DELETE FROM offerproduct WHERE availablequant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMiunquant($value){
		$sql = 'DELETE FROM offerproduct WHERE miunquant = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPrice($value){
		$sql = 'DELETE FROM offerproduct WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotal($value){
		$sql = 'DELETE FROM offerproduct WHERE total = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OfferproductMySql 
	 */
	protected function readRow($row){
		$offerproduct = new Offerproduct();
		
		$offerproduct->id = $row['id'];
		$offerproduct->clientid = $row['clientid'];
		$offerproduct->productid = $row['productid'];
		$offerproduct->quantity = $row['quantity'];
		$offerproduct->storequant = $row['storequant'];
		$offerproduct->availablequant = $row['availablequant'];
		$offerproduct->miunquant = $row['miunquant'];
		$offerproduct->price = $row['price'];
		$offerproduct->total = $row['total'];

		return $offerproduct;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OfferproductMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>