<?php

/**
 * Class that operate on table 'offerpricecondition'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-14 14:25
 */
class OfferpriceconditionMySqlDAO implements OfferpriceconditionDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OfferpriceconditionMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM offerpricecondition WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM offerpricecondition';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM offerpricecondition ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param offerpricecondition primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM offerpricecondition WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OfferpriceconditionMySql offerpricecondition
     */
    public function insert($offerpricecondition) {
        $sql = 'INSERT INTO offerpricecondition (introduction,detail) VALUES (?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setString2($offerpricecondition->introduction);
        $sqlQuery->setString2($offerpricecondition->detail);

        $id = $this->executeInsert($sqlQuery);
        $offerpricecondition->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OfferpriceconditionMySql offerpricecondition
     */
    public function update($offerpricecondition) {
        $sql = 'UPDATE offerpricecondition SET introduction = ? ,detail = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setString2($offerpricecondition->introduction);
        $sqlQuery->setString2($offerpricecondition->detail);

        $sqlQuery->setNumber($offerpricecondition->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM offerpricecondition';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByDetail($value) {
        $sql = 'SELECT * FROM offerpricecondition WHERE detail = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByDetail($value) {
        $sql = 'DELETE FROM offerpricecondition WHERE detail = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OfferpriceconditionMySql
     */
    protected function readRow($row) {
        $offerpricecondition = new Offerpricecondition();

        $offerpricecondition->id = isset($row['id']) ? $row['id'] : '';
        $offerpricecondition->introduction = isset($row['introduction']) ? $row['introduction'] : '';
        $offerpricecondition->detail = isset($row['detail']) ? $row['detail'] : '';

        return $offerpricecondition;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OfferpriceconditionMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>