<?php

/**
 * Class that operate on table 'offerpricebill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-13 15:29
 */
class OfferpricebillMySqlDAO implements OfferpricebillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OfferpricebillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM offerpricebill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM offerpricebill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM offerpricebill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param offerpricebill primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM offerpricebill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OfferpricebillMySql offerpricebill
     */
    public function insert($offerpricebill) {
        $sql = 'INSERT INTO offerpricebill (offerpricebillid, productid, productname, sellprice, prodescrption, pronumber, totalprice) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($offerpricebill->offerpricebillid);
        $sqlQuery->setNumber($offerpricebill->productid);
        $sqlQuery->set($offerpricebill->productname);
        $sqlQuery->set($offerpricebill->sellprice);
        $sqlQuery->set($offerpricebill->prodescrption);
        $sqlQuery->setNumber($offerpricebill->pronumber);
        $sqlQuery->set($offerpricebill->totalprice);

        $id = $this->executeInsert($sqlQuery);
        $offerpricebill->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OfferpricebillMySql offerpricebill
     */
    public function update($offerpricebill) {
        $sql = 'UPDATE offerpricebill SET offerpricebillid = ?, productid = ?, productname = ?, sellprice = ?, prodescrption = ?, pronumber = ?, totalprice = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($offerpricebill->offerpricebillid);
        $sqlQuery->setNumber($offerpricebill->productid);
        $sqlQuery->set($offerpricebill->productname);
        $sqlQuery->set($offerpricebill->sellprice);
        $sqlQuery->set($offerpricebill->prodescrption);
        $sqlQuery->setNumber($offerpricebill->pronumber);
        $sqlQuery->set($offerpricebill->totalprice);

        $sqlQuery->setNumber($offerpricebill->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM offerpricebill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOfferpricebillid($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE offerpricebillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductname($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE productname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellprice($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE sellprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProdescrption($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE prodescrption = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPronumber($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE pronumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalprice($value) {
        $sql = 'SELECT * FROM offerpricebill WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOfferpricebillid($value) {
        $sql = 'DELETE FROM offerpricebill WHERE offerpricebillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM offerpricebill WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductname($value) {
        $sql = 'DELETE FROM offerpricebill WHERE productname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellprice($value) {
        $sql = 'DELETE FROM offerpricebill WHERE sellprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProdescrption($value) {
        $sql = 'DELETE FROM offerpricebill WHERE prodescrption = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPronumber($value) {
        $sql = 'DELETE FROM offerpricebill WHERE pronumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalprice($value) {
        $sql = 'DELETE FROM offerpricebill WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OfferpricebillMySql
     */
    protected function readRow($row) {
        $offerpricebill = new Offerpricebill();

        $offerpricebill->id = isset($row['id']) ? $row['id'] : '';
        $offerpricebill->offerpricebillid = isset($row['offerpricebillid']) ? $row['offerpricebillid'] : '';
        $offerpricebill->productid = isset($row['productid']) ? $row['productid'] : '';
        $offerpricebill->productname = isset($row['productname']) ? $row['productname'] : '';
        $offerpricebill->sellprice = isset($row['sellprice']) ? $row['sellprice'] : '';
        $offerpricebill->prodescrption = isset($row['prodescrption']) ? $row['prodescrption'] : '';
        $offerpricebill->pronumber = isset($row['pronumber']) ? $row['pronumber'] : '';
        $offerpricebill->totalprice = isset($row['totalprice']) ? $row['totalprice'] : '';

        return $offerpricebill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OfferpricebillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>