<?php
/**
 * Class that operate on table 'offerclient'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-09-24 12:55
 */
class OfferclientMySqlDAO implements OfferclientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OfferclientMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM offerclient WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM offerclient';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM offerclient ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param offerclient primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM offerclient WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OfferclientMySql offerclient
 	 */
	public function insert($offerclient){
		$sql = 'INSERT INTO offerclient (datenow, userid, del, client, mydate, alltotal, allquantity, allquantstore, pricestore, allquantavailable, priceavailable, allquantmiun, pricemiun, oldoffer) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($offerclient->datenow);
		$sqlQuery->setNumber($offerclient->userid);
		$sqlQuery->setNumber($offerclient->del);
		$sqlQuery->setNumber($offerclient->client);
		$sqlQuery->set($offerclient->mydate);
		$sqlQuery->setNumber($offerclient->alltotal);
		$sqlQuery->setNumber($offerclient->allquantity);
		$sqlQuery->setNumber($offerclient->allquantstore);
		$sqlQuery->setNumber($offerclient->pricestore);
		$sqlQuery->setNumber($offerclient->allquantavailable);
		$sqlQuery->setNumber($offerclient->priceavailable);
		$sqlQuery->setNumber($offerclient->allquantmiun);
		$sqlQuery->setNumber($offerclient->pricemiun);
		$sqlQuery->setNumber($offerclient->oldoffer);

		$id = $this->executeInsert($sqlQuery);	
		$offerclient->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OfferclientMySql offerclient
 	 */
	public function update($offerclient){
		$sql = 'UPDATE offerclient SET datenow = ?, userid = ?, del = ?, client = ?, mydate = ?, alltotal = ?, allquantity = ?, allquantstore = ?, pricestore = ?, allquantavailable = ?, priceavailable = ?, allquantmiun = ?, pricemiun = ?, oldoffer = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($offerclient->datenow);
		$sqlQuery->setNumber($offerclient->userid);
		$sqlQuery->setNumber($offerclient->del);
		$sqlQuery->setNumber($offerclient->client);
		$sqlQuery->set($offerclient->mydate);
		$sqlQuery->setNumber($offerclient->alltotal);
		$sqlQuery->setNumber($offerclient->allquantity);
		$sqlQuery->setNumber($offerclient->allquantstore);
		$sqlQuery->setNumber($offerclient->pricestore);
		$sqlQuery->setNumber($offerclient->allquantavailable);
		$sqlQuery->setNumber($offerclient->priceavailable);
		$sqlQuery->setNumber($offerclient->allquantmiun);
		$sqlQuery->setNumber($offerclient->pricemiun);
		$sqlQuery->setNumber($offerclient->oldoffer);

		$sqlQuery->setNumber($offerclient->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM offerclient';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDatenow($value){
		$sql = 'SELECT * FROM offerclient WHERE datenow = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM offerclient WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM offerclient WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM offerclient WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMydate($value){
		$sql = 'SELECT * FROM offerclient WHERE mydate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAlltotal($value){
		$sql = 'SELECT * FROM offerclient WHERE alltotal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantity($value){
		$sql = 'SELECT * FROM offerclient WHERE allquantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantstore($value){
		$sql = 'SELECT * FROM offerclient WHERE allquantstore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPricestore($value){
		$sql = 'SELECT * FROM offerclient WHERE pricestore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantavailable($value){
		$sql = 'SELECT * FROM offerclient WHERE allquantavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPriceavailable($value){
		$sql = 'SELECT * FROM offerclient WHERE priceavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantmiun($value){
		$sql = 'SELECT * FROM offerclient WHERE allquantmiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPricemiun($value){
		$sql = 'SELECT * FROM offerclient WHERE pricemiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOldoffer($value){
		$sql = 'SELECT * FROM offerclient WHERE oldoffer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDatenow($value){
		$sql = 'DELETE FROM offerclient WHERE datenow = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM offerclient WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM offerclient WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM offerclient WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMydate($value){
		$sql = 'DELETE FROM offerclient WHERE mydate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAlltotal($value){
		$sql = 'DELETE FROM offerclient WHERE alltotal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantity($value){
		$sql = 'DELETE FROM offerclient WHERE allquantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantstore($value){
		$sql = 'DELETE FROM offerclient WHERE allquantstore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPricestore($value){
		$sql = 'DELETE FROM offerclient WHERE pricestore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantavailable($value){
		$sql = 'DELETE FROM offerclient WHERE allquantavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPriceavailable($value){
		$sql = 'DELETE FROM offerclient WHERE priceavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantmiun($value){
		$sql = 'DELETE FROM offerclient WHERE allquantmiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPricemiun($value){
		$sql = 'DELETE FROM offerclient WHERE pricemiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOldoffer($value){
		$sql = 'DELETE FROM offerclient WHERE oldoffer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OfferclientMySql 
	 */
	protected function readRow($row){
		$offerclient = new Offerclient();
		
		$offerclient->id = $row['id'];
		$offerclient->datenow = $row['datenow'];
		$offerclient->userid = $row['userid'];
		$offerclient->del = $row['del'];
		$offerclient->client = $row['client'];
		$offerclient->mydate = $row['mydate'];
		$offerclient->alltotal = $row['alltotal'];
		$offerclient->allquantity = $row['allquantity'];
		$offerclient->allquantstore = $row['allquantstore'];
		$offerclient->pricestore = $row['pricestore'];
		$offerclient->allquantavailable = $row['allquantavailable'];
		$offerclient->priceavailable = $row['priceavailable'];
		$offerclient->allquantmiun = $row['allquantmiun'];
		$offerclient->pricemiun = $row['pricemiun'];
		$offerclient->oldoffer = $row['oldoffer'];

		return $offerclient;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OfferclientMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>