<?php

/**
 * Class that operate on table 'newdbbackup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 14:44
 */
class NewdbbackupMySqlDAO implements NewdbbackupDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return NewdbbackupMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM newdbbackup WHERE backupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM newdbbackup';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM newdbbackup ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param newdbbackup primary key
     */
    public function delete($backupid) {
        $sql = 'DELETE FROM newdbbackup WHERE backupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($backupid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param NewdbbackupMySql newdbbackup
     */
    public function insert($newdbbackup) {
        $sql = 'INSERT INTO newdbbackup (backupname, backupdate) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($newdbbackup->backupname);
        $sqlQuery->set($newdbbackup->backupdate);

        $id = $this->executeInsert($sqlQuery);
        $newdbbackup->backupid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param NewdbbackupMySql newdbbackup
     */
    public function update($newdbbackup) {
        $sql = 'UPDATE newdbbackup SET backupname = ?, backupdate = ?  WHERE backupid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($newdbbackup->backupname);
        $sqlQuery->set($newdbbackup->backupdate);

        $sqlQuery->setNumber($newdbbackup->backupid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM newdbbackup';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBackupname($value) {
        $sql = 'SELECT * FROM newdbbackup WHERE backupname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBackupname($value) {
        $sql = 'DELETE FROM newdbbackup WHERE backupname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return NewdbbackupMySql
     */
    protected function readRow($row) {
        $newdbbackup = new Newdbbackup();

        $newdbbackup->backupid = isset($row['backupid']) ? $row['backupid'] : '';
        $newdbbackup->backupname = isset($row['backupname']) ? $row['backupname'] : '';
        $newdbbackup->backupdate = isset($row['backupdate']) ? $row['backupdate'] : '';


        return $newdbbackup;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return NewdbbackupMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>