<?php

/**
 * Class that operate on table 'movementmanage'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class MovementmanageMySqlDAO implements MovementmanageDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MovementmanageMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM movementmanage WHERE movementmanageid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM movementmanage';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM movementmanage ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param movementmanage primary key
     */
    public function delete($movementmanageid) {
        $sql = 'DELETE FROM movementmanage WHERE movementmanageid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($movementmanageid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MovementmanageMySql movementmanage
     */
    public function insert($movementmanage) {
        $sql = 'INSERT INTO movementmanage (operationname, movementmanagedate, userid, currentDo, ip, mac, deviceType) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($movementmanage->operationname);
        $sqlQuery->set($movementmanage->movementmanagedate);
        $sqlQuery->setNumber($movementmanage->userid);
        $sqlQuery->set($movementmanage->currentDo);
        $sqlQuery->set($movementmanage->ip);
        $sqlQuery->set($movementmanage->mac);
        $sqlQuery->set($movementmanage->deviceType);

        $id = $this->executeInsert($sqlQuery);
        $movementmanage->movementmanageid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MovementmanageMySql movementmanage
     */
    public function update($movementmanage) {
        $sql = 'UPDATE movementmanage SET operationname = ?, movementmanagedate = ?, userid = ?, currentDo = ?, ip = ?, mac = ?, deviceType = ? WHERE movementmanageid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($movementmanage->operationname);
        $sqlQuery->set($movementmanage->movementmanagedate);
        $sqlQuery->setNumber($movementmanage->userid);
        $sqlQuery->set($movementmanage->currentDo);
        $sqlQuery->set($movementmanage->ip);
        $sqlQuery->set($movementmanage->mac);
        $sqlQuery->set($movementmanage->deviceType);

        $sqlQuery->setNumber($movementmanage->movementmanageid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM movementmanage';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOperationname($value) {
        $sql = 'SELECT * FROM movementmanage WHERE operationname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMovementmanagedate($value) {
        $sql = 'SELECT * FROM movementmanage WHERE movementmanagedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM movementmanage WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOperationname($value) {
        $sql = 'DELETE FROM movementmanage WHERE operationname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMovementmanagedate($value) {
        $sql = 'DELETE FROM movementmanage WHERE movementmanagedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM movementmanage WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MovementmanageMySql
     */
    protected function readRow($row) {
        $movementmanage = new Movementmanage();

        $movementmanage->movementmanageid = isset($row['movementmanageid']) ? $row['movementmanageid'] : '';
        $movementmanage->operationname = isset($row['operationname']) ? $row['operationname'] : '';
        $movementmanage->movementmanagedate = isset($row['movementmanagedate']) ? $row['movementmanagedate'] : '';
        $movementmanage->userid = isset($row['userid']) ? $row['userid'] : '';
        $movementmanage->currentDo = isset($row['currentDo']) ? $row['currentDo'] : '';
        $movementmanage->ip = isset($row['ip']) ? $row['ip'] : '';
        $movementmanage->mac = isset($row['mac']) ? $row['mac'] : '';
        $movementmanage->deviceType = isset($row['deviceType']) ? $row['deviceType'] : '';

        //required
        $movementmanage->username = isset($row['username']) ? $row['username'] : '';

        return $movementmanage;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MovementmanageMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>