<?php

/**
 * Class that operate on table 'm_stage'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MStageMySqlDAO implements MStageDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MStageMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_stage WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_stage';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_stage ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mStage primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM m_stage WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MStageMySql mStage
     */
    public function insert($mStage) {
        $sql = 'INSERT INTO m_stage (title, descreption) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mStage->title);
        $sqlQuery->set($mStage->descreption);

        $id = $this->executeInsert($sqlQuery);
        $mStage->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MStageMySql mStage
     */
    public function update($mStage) {
        $sql = 'UPDATE m_stage SET title = ?, descreption = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mStage->title);
        $sqlQuery->set($mStage->descreption);

        $sqlQuery->setNumber($mStage->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_stage';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTitle($value) {
        $sql = 'SELECT * FROM m_stage WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescreption($value) {
        $sql = 'SELECT * FROM m_stage WHERE descreption = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTitle($value) {
        $sql = 'DELETE FROM m_stage WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescreption($value) {
        $sql = 'DELETE FROM m_stage WHERE descreption = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MStageMySql
     */
    protected function readRow($row) {
        $mStage = new MStage();

        $mStage->id = isset($row['id']) ? $row['id'] : '';
        $mStage->title = isset($row['title']) ? $row['title'] : '';
        $mStage->descreption = isset($row['descreption']) ? $row['descreption'] : '';

        return $mStage;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MStageMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>