<?php

/**
 * Class that operate on table 'm_maintenancereceiptfinish'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MMaintenancereceiptfinishMySqlDAO implements MMaintenancereceiptfinishDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MMaintenancereceiptfinishMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE maintenanceReceiptFinishId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mMaintenancereceiptfinish primary key
     */
    public function delete($maintenanceReceiptFinishId) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE maintenanceReceiptFinishId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($maintenanceReceiptFinishId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MMaintenancereceiptfinishMySql mMaintenancereceiptfinish
     */
    public function insert($mMaintenancereceiptfinish) {
        $sql = 'INSERT INTO m_maintenancereceiptfinish (maintenanceReceiptId, finishingPayedId, payed, remain, maintenanceReceiptFinishDate, userId, branchId, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mMaintenancereceiptfinish->maintenanceReceiptId);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->finishingPayedId);
        $sqlQuery->set($mMaintenancereceiptfinish->payed);
        $sqlQuery->set($mMaintenancereceiptfinish->remain);
        $sqlQuery->set($mMaintenancereceiptfinish->maintenanceReceiptFinishDate);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->userId);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->branchId);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->del);

        $id = $this->executeInsert($sqlQuery);
        $mMaintenancereceiptfinish->maintenanceReceiptFinishId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MMaintenancereceiptfinishMySql mMaintenancereceiptfinish
     */
    public function update($mMaintenancereceiptfinish) {
        $sql = 'UPDATE m_maintenancereceiptfinish SET maintenanceReceiptId = ?, finishingPayedId = ?, payed = ?, remain = ?, maintenanceReceiptFinishDate = ?, userId = ?, branchId = ?, del = ? WHERE maintenanceReceiptFinishId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mMaintenancereceiptfinish->maintenanceReceiptId);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->finishingPayedId);
        $sqlQuery->set($mMaintenancereceiptfinish->payed);
        $sqlQuery->set($mMaintenancereceiptfinish->remain);
        $sqlQuery->set($mMaintenancereceiptfinish->maintenanceReceiptFinishDate);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->userId);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->branchId);
        $sqlQuery->setNumber($mMaintenancereceiptfinish->del);

        $sqlQuery->setNumber($mMaintenancereceiptfinish->maintenanceReceiptFinishId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_maintenancereceiptfinish';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByMaintenanceReceiptId($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE maintenanceReceiptId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinishingPayedId($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE finishingPayedId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayed($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRemain($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE remain = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMaintenanceReceiptFinishDate($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE maintenanceReceiptFinishDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_maintenancereceiptfinish WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByMaintenanceReceiptId($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE maintenanceReceiptId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinishingPayedId($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE finishingPayedId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayed($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRemain($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE remain = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMaintenanceReceiptFinishDate($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE maintenanceReceiptFinishDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_maintenancereceiptfinish WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MMaintenancereceiptfinishMySql
     */
    protected function readRow($row) {
        $mMaintenancereceiptfinish = new MMaintenancereceiptfinish();

        $mMaintenancereceiptfinish->maintenanceReceiptFinishId = isset($row['maintenanceReceiptFinishId']) ? $row['maintenanceReceiptFinishId'] : '';
        $mMaintenancereceiptfinish->maintenanceReceiptId = isset($row['maintenanceReceiptId']) ? $row['maintenanceReceiptId'] : '';
        $mMaintenancereceiptfinish->finishingPayedId = isset($row['finishingPayedId']) ? $row['finishingPayedId'] : '';
        $mMaintenancereceiptfinish->payed = isset($row['payed']) ? $row['payed'] : '';
        $mMaintenancereceiptfinish->remain = isset($row['remain']) ? $row['remain'] : '';
        $mMaintenancereceiptfinish->maintenanceReceiptFinishDate = isset($row['maintenanceReceiptFinishDate']) ? $row['maintenanceReceiptFinishDate'] : '';
        $mMaintenancereceiptfinish->userId = isset($row['userId']) ? $row['userId'] : '';
        $mMaintenancereceiptfinish->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mMaintenancereceiptfinish->del = isset($row['del']) ? $row['del'] : '';

        return $mMaintenancereceiptfinish;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MMaintenancereceiptfinishMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>