<?php

/**
 * Class that operate on table 'government'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-12-29 21:43
 */
class GovernmentMySqlDAO implements GovernmentDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return GovernmentMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM government WHERE governmetid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM government';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM government ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param government primary key
     */
    public function delete($governmetid) {
        $sql = 'DELETE FROM government WHERE governmetid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($governmetid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param GovernmentMySql government
     */
    public function insert($government) {
        $sql = 'INSERT INTO government (governmentname) VALUES (?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($government->governmentname);

        $id = $this->executeInsert($sqlQuery);
        $government->governmetid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param GovernmentMySql government
     */
    public function update($government) {
        $sql = 'UPDATE government SET governmentname = ? WHERE governmetid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($government->governmentname);

        $sqlQuery->setNumber($government->governmetid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM government';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByGovernmentname($value) {
        $sql = 'SELECT * FROM government WHERE governmentname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByGovernmentname($value) {
        $sql = 'DELETE FROM government WHERE governmentname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return GovernmentMySql
     */
    protected function readRow($row) {
        $government = new Government();

        $government->governmetid = isset($row['governmetid']) ? $row['governmetid'] : '';
        $government->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';

        return $government;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return GovernmentMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>