<?php
/**
 * Class that operate on table 'faidaproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-09-13 19:38
 */
class FaidaproductMySqlDAO implements FaidaproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return FaidaproductMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM faidaproduct WHERE faida_prod_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM faidaproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM faidaproduct ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param faidaproduct primary key
 	 */
	public function delete($faida_prod_id){
		$sql = 'DELETE FROM faidaproduct WHERE faida_prod_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($faida_prod_id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param FaidaproductMySql faidaproduct
 	 */
	public function insert($faidaproduct){
		$sql = 'INSERT INTO faidaproduct (parcode, comment, productunit, pronum, scunitname, bouns, pricetypepro, proprice, discounttype, Faida_id, product_id ,conditions ,faidaproducttotalprice) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($faidaproduct->parcode);
		$sqlQuery->setString2($faidaproduct->comment);
		$sqlQuery->set($faidaproduct->productunit);
		$sqlQuery->set($faidaproduct->pronum);
		$sqlQuery->setNumber($faidaproduct->scunitname);
		$sqlQuery->set($faidaproduct->bouns);
		$sqlQuery->setNumber($faidaproduct->pricetypepro);
		$sqlQuery->setNumber($faidaproduct->proprice);
		$sqlQuery->set($faidaproduct->discounttype);
		$sqlQuery->setNumber($faidaproduct->faidaId);
		$sqlQuery->setNumber($faidaproduct->productId);
		$sqlQuery->setNumber($faidaproduct->conditions);
		$sqlQuery->setNumber($faidaproduct->faidaproducttotalprice);
//echo $sql;
		$id = $this->executeInsert($sqlQuery);	
		$faidaproduct->faidaProdId = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param FaidaproductMySql faidaproduct
 	 */
	public function update($faidaproduct){
		$sql = 'UPDATE faidaproduct SET parcode = ?, comment = ?, productunit = ?, pronum = ?, scunitname = ?, bouns = ?, pricetypepro = ?, proprice = ?, discounttype = ?, Faida_id = ?, product_id = ? ,conditions = ? ,faidaproducttotalprice = ? WHERE faida_prod_id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($faidaproduct->parcode);
		$sqlQuery->setString2($faidaproduct->comment);
		$sqlQuery->set($faidaproduct->productunit);
		$sqlQuery->set($faidaproduct->pronum);
		$sqlQuery->setNumber($faidaproduct->scunitname);
		$sqlQuery->set($faidaproduct->bouns);
		$sqlQuery->setNumber($faidaproduct->pricetypepro);
		$sqlQuery->setNumber($faidaproduct->proprice);
		$sqlQuery->set($faidaproduct->discounttype);
		$sqlQuery->setNumber($faidaproduct->faidaId);
		$sqlQuery->setNumber($faidaproduct->productId);
		$sqlQuery->setNumber($faidaproduct->conditions);
		$sqlQuery->setNumber($faidaproduct->faidaproducttotalprice);

		$sqlQuery->setNumber($faidaproduct->faidaProdId);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM faidaproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByParcode($value){
		$sql = 'SELECT * FROM faidaproduct WHERE parcode = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStoryId($value){
		$sql = 'SELECT * FROM faidaproduct WHERE story_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM faidaproduct WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductunit($value){
		$sql = 'SELECT * FROM faidaproduct WHERE productunit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPronum($value){
		$sql = 'SELECT * FROM faidaproduct WHERE pronum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByScunitname($value){
		$sql = 'SELECT * FROM faidaproduct WHERE scunitname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBouns($value){
		$sql = 'SELECT * FROM faidaproduct WHERE bouns = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPricetypepro($value){
		$sql = 'SELECT * FROM faidaproduct WHERE pricetypepro = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProprice($value){
		$sql = 'SELECT * FROM faidaproduct WHERE proprice = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDiscounttype($value){
		$sql = 'SELECT * FROM faidaproduct WHERE discounttype = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFaidaId($value){
		$sql = 'SELECT * FROM faidaproduct WHERE Faida_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM faidaproduct WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByParcode($value){
		$sql = 'DELETE FROM faidaproduct WHERE parcode = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStoryId($value){
		$sql = 'DELETE FROM faidaproduct WHERE story_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM faidaproduct WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductunit($value){
		$sql = 'DELETE FROM faidaproduct WHERE productunit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPronum($value){
		$sql = 'DELETE FROM faidaproduct WHERE pronum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByScunitname($value){
		$sql = 'DELETE FROM faidaproduct WHERE scunitname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBouns($value){
		$sql = 'DELETE FROM faidaproduct WHERE bouns = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPricetypepro($value){
		$sql = 'DELETE FROM faidaproduct WHERE pricetypepro = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProprice($value){
		$sql = 'DELETE FROM faidaproduct WHERE proprice = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDiscounttype($value){
		$sql = 'DELETE FROM faidaproduct WHERE discounttype = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFaidaId($value){
		$sql = 'DELETE FROM faidaproduct WHERE Faida_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM faidaproduct WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return FaidaproductMySql 
	 */
	protected function readRow($row){
		$faidaproduct = new Faidaproduct();
		
		$faidaproduct->faidaProdId = $row['faida_prod_id'];
		$faidaproduct->parcode = $row['parcode'];
		$faidaproduct->comment = $row['comment'];
		$faidaproduct->productunit = $row['productunit'];
		$faidaproduct->pronum = $row['pronum'];
		$faidaproduct->scunitname = $row['scunitname'];
		$faidaproduct->bouns = $row['bouns'];
		$faidaproduct->pricetypepro = $row['pricetypepro'];
		$faidaproduct->proprice = $row['proprice'];
		$faidaproduct->discounttype = $row['discounttype'];
		$faidaproduct->faidaId = $row['Faida_id'];
		$faidaproduct->productId = $row['product_id'];
		$faidaproduct->conditions = $row['conditions'];
		$faidaproduct->faidaproducttotalprice = $row['faidaproducttotalprice'];
		$faidaproduct->productName = $row['productName'];
		$faidaproduct->productCatName = $row['productCatName'];
		$faidaproduct->unitName = $row['unitName'];
		$faidaproduct->faidatotal = $row['faidatotal'];
		$faidaproduct->nametotal = $row['nametotal'];

		return $faidaproduct;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return FaidaproductMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>